/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CompressFilterSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressFilterSettings.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bFilterLoaded = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bResponseCompressionEnabled = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bResponseGzipEnabled = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bResponseDeflateEnabled = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugModeEnabled = false;
    private static final CompressFilterSettings INSTANCE = new CompressFilterSettings();

    private CompressFilterSettings() {
    }

    public static boolean isFilterLoaded() {
        return RW_LOCK.readLockedBoolean(() -> s_bFilterLoaded);
    }

    public static void markFilterLoaded() {
        RW_LOCK.writeLockedBoolean(() -> {
            s_bFilterLoaded = true;
            return true;
        });
        LOGGER.info("CompressFilter is loaded");
    }

    public static boolean isResponseCompressionEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bResponseCompressionEnabled);
    }

    @Nonnull
    public static EChange setResponseCompressionEnabled(boolean bl) {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bResponseCompressionEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseCompressionEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseCompressionEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseGzipEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bResponseGzipEnabled);
    }

    @Nonnull
    public static EChange setResponseGzipEnabled(boolean bl) {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bResponseGzipEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseGzipEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseGzipEnabled=" + bl);
        }
        return eChange;
    }

    public static boolean isResponseDeflateEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bResponseDeflateEnabled);
    }

    @Nonnull
    public static EChange setResponseDeflateEnabled(boolean bl) {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bResponseDeflateEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bResponseDeflateEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter responseDeflateEnabled=" + bl);
        }
        return eChange;
    }

    @Nonnull
    public static EChange setAll(boolean bl, boolean bl2, boolean bl3) {
        return CompressFilterSettings.setResponseCompressionEnabled(bl).or((IChangeIndicator)CompressFilterSettings.setResponseGzipEnabled(bl2)).or((IChangeIndicator)CompressFilterSettings.setResponseDeflateEnabled(bl3));
    }

    public static boolean isDebugModeEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugModeEnabled);
    }

    @Nonnull
    public static EChange setDebugModeEnabled(boolean bl) {
        EChange eChange = (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bDebugModeEnabled == bl) {
                return EChange.UNCHANGED;
            }
            s_bDebugModeEnabled = bl;
            return EChange.CHANGED;
        });
        if (eChange.isChanged()) {
            LOGGER.info("CompressFilter debugMode=" + bl);
        }
        return eChange;
    }
}

