/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.io;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.WrappedInputStream;
import com.helger.base.state.ICloseable;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractLimitedInputStream
extends WrappedInputStream
implements ICloseable {
    private final long m_nSizeMax;
    private long m_nCount;
    private boolean m_bClosed;

    public AbstractLimitedInputStream(@Nonnull InputStream inputStream, @Nonnegative long l) {
        super(inputStream);
        this.m_nSizeMax = ValueEnforcer.isGE0((long)l, (String)"SizeMax");
    }

    protected abstract void onLimitExceeded(@Nonnegative long var1, @Nonnegative long var3) throws IOException;

    private void _checkLimit() throws IOException {
        if (this.m_nCount > this.m_nSizeMax) {
            this.onLimitExceeded(this.m_nSizeMax, this.m_nCount);
        }
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nCount;
            this._checkLimit();
        }
        return n;
    }

    public int read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.m_nCount += (long)n3;
            this._checkLimit();
        }
        return n3;
    }

    public boolean isClosed() throws IOException {
        return this.m_bClosed;
    }

    public void close() throws IOException {
        this.m_bClosed = true;
        super.close();
    }
}

