/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.multipart;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.web.progress.IProgressListener;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartProgressNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartProgressNotifier.class);
    private final IProgressListener m_aListener;
    private final long m_nContentLength;
    private long m_nBytesRead;
    private int m_nItems;

    public MultipartProgressNotifier(@Nullable IProgressListener iProgressListener, @CheckForSigned long l) {
        if (iProgressListener != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("setting progress listener " + String.valueOf(iProgressListener));
        }
        this.m_aListener = iProgressListener;
        this.m_nContentLength = l;
    }

    private void _notifyListener() {
        if (this.m_aListener != null) {
            this.m_aListener.update(this.m_nBytesRead, this.m_nContentLength, this.m_nItems);
        }
    }

    void noteBytesRead(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Bytes");
        this.m_nBytesRead += (long)n;
        this._notifyListener();
    }

    public void onNextFileItem() {
        ++this.m_nItems;
        this._notifyListener();
    }
}

