/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.http.header.HttpHeaderMap;
import com.helger.scope.IRequestScope;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.servlet.request.RequestHelper;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestParamContainer;
import com.helger.web.scope.IWebScope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.Charset;
import java.security.Principal;

public interface IRequestWebScopeWithoutResponse
extends IRequestScope,
IWebScope {
    @Nonnull
    @ReturnsMutableObject
    public HttpHeaderMap headers();

    @Nonnull
    @ReturnsMutableObject
    public IRequestParamContainer params();

    @Nonnull
    public IRequestParamMap getRequestParamMap();

    @Nullable
    default public String getSessionID(boolean bl) {
        HttpSession httpSession = this.getSession(bl);
        return httpSession == null ? null : httpSession.getId();
    }

    @Nullable
    default public String getCharacterEncoding() {
        return this.getRequest().getCharacterEncoding();
    }

    @Nullable
    default public String getContentType() {
        return this.getRequest().getContentType();
    }

    @CheckForSigned
    default public long getContentLength() {
        return RequestHelper.getContentLength((HttpServletRequest)this.getRequest());
    }

    @Nullable
    default public Charset getCharset() {
        String string = this.getRequest().getCharacterEncoding();
        return StringHelper.isEmpty((String)string) ? null : CharsetHelper.getCharsetFromName((String)string);
    }

    default public String getProtocol() {
        return this.getRequest().getProtocol();
    }

    @Nullable
    default public EHttpVersion getHttpVersion() {
        return RequestHelper.getHttpVersion((HttpServletRequest)this.getRequest());
    }

    default public String getScheme() {
        return this.getRequest().getScheme();
    }

    default public String getServerName() {
        return this.getRequest().getServerName();
    }

    default public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    default public String getRemoteAddr() {
        return this.getRequest().getRemoteAddr();
    }

    default public String getRemoteHost() {
        return this.getRequest().getRemoteHost();
    }

    default public int getRemotePort() {
        return this.getRequest().getRemotePort();
    }

    default public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    default public String getLocalName() {
        return this.getRequest().getLocalName();
    }

    default public String getLocalAddr() {
        return this.getRequest().getLocalAddr();
    }

    default public int getLocalPort() {
        return this.getRequest().getLocalPort();
    }

    default public String getAuthType() {
        return this.getRequest().getAuthType();
    }

    @Nullable
    default public Cookie[] getCookies() {
        return ServletHelper.getRequestCookies((HttpServletRequest)this.getRequest());
    }

    default public String getMethod() {
        return ServletHelper.getRequestMethod((HttpServletRequest)this.getRequest());
    }

    @Nullable
    default public EHttpMethod getHttpMethod() {
        return RequestHelper.getHttpMethod((HttpServletRequest)this.getRequest());
    }

    default public String getPathInfo() {
        return RequestHelper.getPathInfo((HttpServletRequest)this.getRequest());
    }

    default public String getPathTranslated() {
        return this.getRequest().getPathTranslated();
    }

    @Nonnull
    public String getContextPath();

    default public String getQueryString() {
        return ServletHelper.getRequestQueryString((HttpServletRequest)this.getRequest());
    }

    default public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    default public boolean isUserInRole(String string) {
        return this.getRequest().isUserInRole(string);
    }

    @Nullable
    default public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    @Nonnull
    default public String getRequestURIDecoded() {
        return RequestHelper.getRequestURIDecoded((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    default public String getRequestURIEncoded() {
        return RequestHelper.getRequestURIEncoded((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    @Nonempty
    default public StringBuilder getRequestURLDecoded() {
        return RequestHelper.getRequestURLDecoded((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    @Nonempty
    default public StringBuilder getRequestURLEncoded() {
        return RequestHelper.getRequestURLEncoded((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    default public String getServletPath() {
        return ServletHelper.getRequestServletPath((HttpServletRequest)this.getRequest());
    }

    @Nullable
    default public HttpSession getSession(boolean bl) {
        return ServletHelper.getRequestSession((HttpServletRequest)this.getRequest(), (boolean)bl);
    }

    default public boolean isRequestedSessionIdValid() {
        return this.getRequest().isRequestedSessionIdValid();
    }

    default public boolean isRequestedSessionIdFromCookie() {
        return this.getRequest().isRequestedSessionIdFromCookie();
    }

    default public boolean isRequestedSessionIdFromURL() {
        return this.getRequest().isRequestedSessionIdFromURL();
    }

    @Nonnull
    default public String getFullServerPath() {
        return RequestHelper.getFullServerName((HttpServletRequest)this.getRequest()).toString();
    }

    @Nonnull
    default public String getFullContextPath() {
        return RequestHelper.getFullServerName((HttpServletRequest)this.getRequest()).append(this.getContextPath()).toString();
    }

    @Nonnull
    public String getContextAndServletPath();

    @Nonnull
    public String getFullContextAndServletPath();

    @Nonnull
    @Nonempty
    default public String getURIDecoded() {
        return (String)this.attrs().computeIfAbsent((Object)"$ph-req-uri-decoded", string -> RequestHelper.getURIDecoded((HttpServletRequest)this.getRequest()));
    }

    @Nonnull
    @Nonempty
    default public String getURIEncoded() {
        return (String)this.attrs().computeIfAbsent((Object)"$ph-req-uri-encoded", string -> RequestHelper.getURIEncoded((HttpServletRequest)this.getRequest()));
    }

    @Nonnull
    @Nonempty
    default public String getURLDecoded() {
        return (String)this.attrs().computeIfAbsent((Object)"$ph-req-url-decoded", string -> RequestHelper.getURLDecoded((HttpServletRequest)this.getRequest()));
    }

    @Nonnull
    @Nonempty
    default public String getURLEncoded() {
        return (String)this.attrs().computeIfAbsent((Object)"$ph-req-url-encoded", string -> RequestHelper.getURLEncoded((HttpServletRequest)this.getRequest()));
    }

    @Nonnull
    public String encodeURL(@Nonnull String var1);

    @Nonnull
    default public ISimpleURL encodeURL(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return iSimpleURL.getWithPath(this.encodeURL(iSimpleURL.getPath()));
    }

    @Nonnull
    public String encodeRedirectURL(@Nonnull String var1);

    @Nonnull
    default public ISimpleURL encodeRedirectURL(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return iSimpleURL.getWithPath(this.encodeRedirectURL(iSimpleURL.getPath()));
    }

    default public boolean areCookiesEnabled() {
        return "a".equals(this.encodeURL("a"));
    }

    @Nonnull
    default public String getPathWithinServletContext() {
        return RequestHelper.getPathWithinServletContext((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    default public String getPathWithinServlet() {
        return RequestHelper.getPathWithinServlet((HttpServletRequest)this.getRequest());
    }

    @Nonnull
    public HttpServletRequest getRequest();
}

