/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mgr;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.scope.IGlobalScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.mgr.ScopeManager;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.impl.GlobalWebScope;
import com.helger.web.scope.impl.SessionWebScope;
import com.helger.web.scope.mgr.WebScopeSessionManager;
import com.helger.web.scope.multipart.RequestWebScopeMultipart;
import com.helger.web.scope.session.SessionWebScopeActivator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class WebScopeManager {
    public static final boolean DEFAULT_SESSION_PASSIVATION_ALLOWED = false;
    private static final String SESSION_ATTR_SESSION_SCOPE_ACTIVATOR = "$ph-sessionwebscope.activator";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebScopeManager.class);
    private static final AtomicBoolean SESSION_PASSIVATION_ALLOWED = new AtomicBoolean(false);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ICommonsSet<String> SESSION_IN_INVALIDATION = new CommonsHashSet();
    private static final WebScopeManager INSTANCE = new WebScopeManager();

    private WebScopeManager() {
    }

    public static boolean isSessionPassivationAllowed() {
        return SESSION_PASSIVATION_ALLOWED.get();
    }

    public static void setSessionPassivationAllowed(boolean bl) {
        SESSION_PASSIVATION_ALLOWED.set(bl);
        LOGGER.info("Session passivation is now " + (bl ? "enabled" : "disabled"));
        ScopeSessionManager scopeSessionManager = ScopeSessionManager.getInstance();
        scopeSessionManager.setDestroyAllSessionsOnScopeEnd(!bl);
        scopeSessionManager.setEndAllSessionsOnScopeEnd(!bl);
        for (ISessionWebScope iSessionWebScope : WebScopeSessionManager.getAllSessionWebScopes()) {
            HttpSession httpSession = iSessionWebScope.getSession();
            if (bl) {
                if (httpSession.getAttribute(SESSION_ATTR_SESSION_SCOPE_ACTIVATOR) != null) continue;
                httpSession.setAttribute(SESSION_ATTR_SESSION_SCOPE_ACTIVATOR, (Object)new SessionWebScopeActivator(iSessionWebScope));
                continue;
            }
            httpSession.removeAttribute(SESSION_ATTR_SESSION_SCOPE_ACTIVATOR);
        }
    }

    @Nonnull
    public static IGlobalWebScope onGlobalBegin(@Nonnull ServletContext servletContext) {
        return WebScopeManager.onGlobalBegin(servletContext, GlobalWebScope::new);
    }

    @Nonnull
    public static IGlobalWebScope onGlobalBegin(@Nonnull ServletContext servletContext, @Nonnull Function<? super ServletContext, ? extends IGlobalWebScope> function) {
        IGlobalWebScope iGlobalWebScope = function.apply((ServletContext)servletContext);
        ScopeManager.setGlobalScope((IGlobalScope)iGlobalWebScope);
        return iGlobalWebScope;
    }

    public static boolean isGlobalScopePresent() {
        return ScopeManager.isGlobalScopePresent();
    }

    @Nullable
    public static IGlobalWebScope getGlobalScopeOrNull() {
        IGlobalScope iGlobalScope = ScopeManager.getGlobalScopeOrNull();
        try {
            return (IGlobalWebScope)iGlobalScope;
        }
        catch (ClassCastException classCastException) {
            LOGGER.warn("Gobal scope object is not a global web scope: " + String.valueOf(iGlobalScope), (Throwable)classCastException);
            return null;
        }
    }

    @Nonnull
    public static IGlobalWebScope getGlobalScope() {
        IGlobalWebScope iGlobalWebScope = WebScopeManager.getGlobalScopeOrNull();
        if (iGlobalWebScope == null) {
            throw new IllegalStateException("No global web scope object has been set!");
        }
        return iGlobalWebScope;
    }

    public static void onGlobalEnd() {
        ScopeManager.onGlobalEnd();
    }

    @Nonnull
    public static ISessionWebScope onSessionBegin(@Nonnull HttpSession httpSession) {
        return WebScopeManager.onSessionBegin(httpSession, SessionWebScope::new);
    }

    @Nonnull
    public static <T extends ISessionWebScope> T onSessionBegin(@Nonnull HttpSession httpSession, @Nonnull Function<? super HttpSession, T> function) {
        ISessionWebScope iSessionWebScope = (ISessionWebScope)function.apply((HttpSession)httpSession);
        ScopeSessionManager.getInstance().onScopeBegin((ISessionScope)iSessionWebScope);
        if (WebScopeManager.isSessionPassivationAllowed()) {
            httpSession.setAttribute(SESSION_ATTR_SESSION_SCOPE_ACTIVATOR, (Object)new SessionWebScopeActivator(iSessionWebScope));
        }
        return (T)iSessionWebScope;
    }

    @Nullable
    @DevelopersNote(value="This is only for project-internal use!")
    public static ISessionWebScope internalGetOrCreateSessionScope(@Nonnull HttpSession httpSession, boolean bl, boolean bl2) {
        ValueEnforcer.notNull((Object)httpSession, (String)"HttpSession");
        String string = httpSession.getId();
        ISessionScope iSessionScope = ScopeSessionManager.getInstance().getSessionScopeOfID(string);
        if (iSessionScope == null && bl) {
            if (!bl2) {
                LOGGER.warn("Creating a new session web scope for ID '" + string + "' but there should already be one! Check your HttpSessionListener implementation. Ignore this after a application server restart.");
            }
            iSessionScope = WebScopeManager.onSessionBegin(httpSession);
        }
        try {
            return (ISessionWebScope)iSessionScope;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Session scope object is not a web scope but: " + String.valueOf(iSessionScope), classCastException);
        }
    }

    @Nonnull
    public static ISessionWebScope getSessionScope() {
        return WebScopeManager.getSessionScope(true);
    }

    @Nullable
    public static ISessionWebScope getSessionScope(boolean bl) {
        return WebScopeManager.internalGetSessionScope(bl, false);
    }

    @Nullable
    @DevelopersNote(value="This is only for project-internal use!")
    public static ISessionWebScope internalGetSessionScope(boolean bl, boolean bl2) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScopeOrNull();
        return WebScopeManager.internalGetSessionScope(iRequestWebScope, bl, bl2);
    }

    @Nullable
    @DevelopersNote(value="This is only for project-internal use!")
    public static ISessionWebScope internalGetSessionScope(@Nullable IRequestWebScope iRequestWebScope, boolean bl, boolean bl2) {
        if (iRequestWebScope != null) {
            HttpSession httpSession = iRequestWebScope.getSession(bl);
            if (httpSession != null) {
                return WebScopeManager.internalGetOrCreateSessionScope(httpSession, bl, bl2);
            }
        } else if (bl) {
            throw new IllegalStateException("No request scope is present, so no session scope can be retrieved!");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onSessionEnd(@Nonnull HttpSession httpSession) {
        ValueEnforcer.notNull((Object)httpSession, (String)"HttpSession");
        ScopeSessionManager scopeSessionManager = ScopeSessionManager.getInstance();
        String string = httpSession.getId();
        ISessionScope iSessionScope = scopeSessionManager.getSessionScopeOfID(string);
        if (iSessionScope != null) {
            scopeSessionManager.onScopeEnd(iSessionScope);
        } else {
            boolean bl = RW_LOCK.writeLockedBoolean(() -> SESSION_IN_INVALIDATION.add((Object)string));
            if (bl) {
                try {
                    httpSession.invalidate();
                    LOGGER.warn("Found no session scope but invalidated session '" + string + "' anyway");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    RW_LOCK.writeLocked(() -> SESSION_IN_INVALIDATION.remove((Object)string));
                }
            }
        }
    }

    @Nonnull
    public static IRequestWebScope onRequestBegin(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        return WebScopeManager.onRequestBegin(httpServletRequest, httpServletResponse, RequestWebScopeMultipart::new);
    }

    @Nonnull
    public static <T extends IRequestWebScope> T onRequestBegin(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull BiFunction<? super HttpServletRequest, ? super HttpServletResponse, T> biFunction) {
        IRequestWebScope iRequestWebScope = (IRequestWebScope)biFunction.apply((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        ScopeManager.internalSetAndInitRequestScope((IRequestScope)iRequestWebScope);
        return (T)iRequestWebScope;
    }

    @Nullable
    public static IRequestWebScope getRequestScopeOrNull() {
        IRequestScope iRequestScope = ScopeManager.getRequestScopeOrNull();
        try {
            return (IRequestWebScope)iRequestScope;
        }
        catch (ClassCastException classCastException) {
            LOGGER.warn("Request scope object is not a request web scope: " + String.valueOf(iRequestScope), (Throwable)classCastException);
            return null;
        }
    }

    public static boolean isRequestScopePresent() {
        return ScopeManager.getRequestScopeOrNull() instanceof IRequestWebScope;
    }

    @Nonnull
    public static IRequestWebScope getRequestScope() {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScopeOrNull();
        if (iRequestWebScope == null) {
            throw new IllegalStateException("No request web scope object has been set!");
        }
        return iRequestWebScope;
    }

    public static void onRequestEnd() {
        ScopeManager.onRequestEnd();
    }
}

