/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.cleanup.CleanUpRegistry;
import com.helger.http.EHttpMethod;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.mock.MockServletContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletContext;
import java.util.Map;

@Immutable
public final class WebScopeAwareTestSetup {
    public static final String MOCK_CONTEXT_PATH = "/MockContext";
    private static final WebScopeAwareTestSetup INSTANCE = new WebScopeAwareTestSetup();

    private WebScopeAwareTestSetup() {
    }

    @Nonnull
    public static MockServletContext createDefaultMockServletContext() {
        return WebScopeAwareTestSetup.createDefaultMockServletContext(MOCK_CONTEXT_PATH, null);
    }

    @Nonnull
    public static MockServletContext createDefaultMockServletContext(@Nullable String string, @Nullable Map<String, String> map) {
        return MockServletContext.create((String)string, map);
    }

    @Nonnull
    public static MockHttpServletRequest createDefaultMockRequest(@Nonnull MockServletContext mockServletContext) {
        return new MockHttpServletRequest((ServletContext)mockServletContext, EHttpMethod.GET);
    }

    public static void shutdownWebScopeTests(@Nullable MockHttpServletRequest mockHttpServletRequest, @Nullable MockServletContext mockServletContext) {
        if (mockHttpServletRequest != null) {
            mockHttpServletRequest.invalidate();
        }
        if (mockServletContext != null) {
            mockServletContext.invalidate();
        }
        CleanUpRegistry.getInstance().performCleanUp();
    }
}

