/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mock;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.servlet.mock.MockHttpListener;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.mock.MockServletContext;
import com.helger.servlet.mock.MockServletPool;
import com.helger.web.scope.mock.MockServletRequestListenerScopeAware;
import com.helger.web.scope.mock.WebScopeAwareTestSetup;
import com.helger.web.servlets.scope.WebScopeListener;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpSession;
import java.util.EventListener;
import java.util.Map;
import org.junit.rules.ExternalResource;

@NotThreadSafe
public class WebScopeTestRule
extends ExternalResource {
    public static final String MOCK_CONTEXT_PATH = "/MockContext";
    private String m_sContextPath = "/MockContext";
    private ICommonsMap<String, String> m_aServletContextInitParameters;
    private MockServletContext m_aMockServletContext;
    private MockHttpServletRequest m_aMockRequest;

    public WebScopeTestRule() {
        this(null);
    }

    public WebScopeTestRule(@Nullable ICommonsMap<String, String> iCommonsMap) {
        this.m_aServletContextInitParameters = iCommonsMap;
    }

    @Nonnull
    public final WebScopeTestRule setContextPath(@Nullable String string) {
        this.m_sContextPath = string;
        return this;
    }

    @Nullable
    public final String getContextPath() {
        return this.m_sContextPath;
    }

    @Nonnull
    public final WebScopeTestRule setServletContextInitParameters(@Nullable ICommonsMap<String, String> iCommonsMap) {
        this.m_aServletContextInitParameters = iCommonsMap;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, String> getServletContextInitParameters() {
        return new CommonsHashMap(this.m_aServletContextInitParameters);
    }

    @OverrideOnDemand
    protected void initListener() {
        MockHttpListener.removeAllDefaultListeners();
        MockHttpListener.addDefaultListener((EventListener)((Object)new WebScopeListener()));
        MockHttpListener.addDefaultListener((EventListener)((Object)new MockServletRequestListenerScopeAware()));
        MockHttpListener.setCurrentToDefault();
    }

    @Nonnull
    @OverrideOnDemand
    protected MockServletContext createMockServletContext(@Nullable String string, @Nullable Map<String, String> map) {
        return WebScopeAwareTestSetup.createDefaultMockServletContext(string, map);
    }

    @Nullable
    @OverrideOnDemand
    protected MockHttpServletRequest createMockRequest(@Nonnull MockServletContext mockServletContext) {
        return WebScopeAwareTestSetup.createDefaultMockRequest(mockServletContext);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void before() {
        this.initListener();
        this.m_aMockServletContext = this.createMockServletContext(this.m_sContextPath, (Map<String, String>)this.m_aServletContextInitParameters);
        if (this.m_aMockServletContext == null) {
            throw new IllegalStateException("Failed to created MockServletContext");
        }
        this.m_aMockRequest = this.createMockRequest(this.m_aMockServletContext);
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public void after() {
        WebScopeAwareTestSetup.shutdownWebScopeTests(this.m_aMockRequest, this.m_aMockServletContext);
        this.m_aMockRequest = null;
        this.m_aMockServletContext = null;
    }

    @Nullable
    public final MockServletContext getServletContext() {
        return this.m_aMockServletContext;
    }

    @Nullable
    public final MockServletPool getServletPool() {
        return this.m_aMockServletContext == null ? null : this.m_aMockServletContext.getServletPool();
    }

    @Nullable
    public final MockHttpServletRequest getRequest() {
        return this.m_aMockRequest;
    }

    @Nullable
    public final HttpSession getSession(boolean bl) {
        return this.m_aMockRequest == null ? null : this.m_aMockRequest.getSession(bl);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("ContextPath", (Object)this.m_sContextPath).appendIfNotNull("ServletContextInitParams", this.m_aServletContextInitParameters).append("MockServletContext", (Object)this.m_aMockServletContext).appendIfNotNull("MockRequest", (Object)this.m_aMockRequest).getToString();
    }
}

