/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.multipart;

import com.helger.base.array.ArrayHelper;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.CWeb;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.fileupload.IFileItemFactoryProviderSPI;
import com.helger.web.fileupload.exception.FileUploadException;
import com.helger.web.fileupload.servlet.ServletFileUpload;
import com.helger.web.progress.IProgressListener;
import com.helger.web.progress.ProgressListenerProvider;
import com.helger.web.scope.multipart.GlobalDiskFileItemFactory;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestMultipartHelper {
    public static final long MAX_REQUEST_SIZE = 0x140000000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestMultipartHelper.class);
    private static final IFileItemFactoryProviderSPI PROVIDER;

    private RequestMultipartHelper() {
    }

    @Nonnull
    public static EChange handleMultipartFormData(@Nonnull HttpServletRequest httpServletRequest, @Nonnull BiConsumer<String, Object> biConsumer) {
        if (httpServletRequest instanceof MockHttpServletRequest) {
            return EChange.UNCHANGED;
        }
        if (!RequestHelper.isMultipartFormDataContent((HttpServletRequest)httpServletRequest)) {
            return EChange.UNCHANGED;
        }
        boolean bl = false;
        try {
            Object[] objectArray;
            ICommonsList iCommonsList;
            ServletFileUpload servletFileUpload = new ServletFileUpload(PROVIDER.getFileItemFactory());
            servletFileUpload.setSizeMax(0x140000000L);
            servletFileUpload.setHeaderEncoding(CWeb.CHARSET_REQUEST_OBJ.name());
            IProgressListener iProgressListener = ProgressListenerProvider.getProgressListener();
            if (iProgressListener != null) {
                servletFileUpload.setProgressListener(iProgressListener);
            }
            ServletHelper.setRequestCharacterEncoding((HttpServletRequest)httpServletRequest, (Charset)CWeb.CHARSET_REQUEST_OBJ);
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            CommonsHashMap commonsHashMap2 = new CommonsHashMap();
            ICommonsList<IFileItem> iCommonsList2 = servletFileUpload.parseRequest(httpServletRequest);
            for (Object object : iCommonsList2) {
                if (object.isFormField()) {
                    ((ICommonsList)commonsHashMap.computeIfAbsent((Object)object.getFieldName(), string -> new CommonsArrayList())).add((Object)object.getString(CWeb.CHARSET_REQUEST_OBJ));
                    continue;
                }
                ((ICommonsList)commonsHashMap2.computeIfAbsent((Object)object.getFieldName(), string -> new CommonsArrayList())).add(object);
            }
            for (Object object : commonsHashMap.entrySet()) {
                iCommonsList = (ICommonsList)object.getValue();
                objectArray = iCommonsList.size() == 1 ? iCommonsList.getFirstOrNull() : ArrayHelper.createArray((Collection)iCommonsList, String.class);
                biConsumer.accept((String)object.getKey(), objectArray);
            }
            for (Object object : commonsHashMap2.entrySet()) {
                iCommonsList = (ICommonsList)object.getValue();
                objectArray = iCommonsList.size() == 1 ? iCommonsList.getFirstOrNull() : ArrayHelper.createArray((Collection)iCommonsList, IFileItem.class);
                biConsumer.accept((String)object.getKey(), objectArray);
            }
            bl = true;
        }
        catch (FileUploadException fileUploadException) {
            if (!StreamHelper.isKnownEOFException((Throwable)fileUploadException.getCause())) {
                LOGGER.error("Error parsing multipart request content", (Throwable)fileUploadException);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error parsing multipart request content", (Throwable)runtimeException);
        }
        return EChange.valueOf((boolean)bl);
    }

    static {
        IFileItemFactoryProviderSPI iFileItemFactoryProviderSPI = (IFileItemFactoryProviderSPI)ServiceLoaderHelper.getFirstSPIImplementation(IFileItemFactoryProviderSPI.class);
        if (iFileItemFactoryProviderSPI != null) {
            LOGGER.info("Using custom IFileItemFactoryProviderSPI " + String.valueOf(iFileItemFactoryProviderSPI));
        } else {
            iFileItemFactoryProviderSPI = GlobalDiskFileItemFactory::getInstance;
        }
        PROVIDER = iFileItemFactoryProviderSPI;
    }
}

