/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.util;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.helper.CollectionEqualsHelper;
import com.helger.web.scope.util.AbstractRequestFieldData;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

@Immutable
public class RequestFieldDataMultiValue
extends AbstractRequestFieldData {
    private final ICommonsList<String> m_aDefaultValues;

    public RequestFieldDataMultiValue(@Nonnull RequestFieldDataMultiValue requestFieldDataMultiValue) {
        this(requestFieldDataMultiValue.getFieldName(), (Collection<String>)requestFieldDataMultiValue.m_aDefaultValues);
    }

    public RequestFieldDataMultiValue(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public RequestFieldDataMultiValue(@Nonnull @Nonempty String string, @Nullable Collection<String> collection) {
        super(string);
        this.m_aDefaultValues = new CommonsArrayList(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    public ICommonsList<String> getDefaultValues() {
        return (ICommonsList)this.m_aDefaultValues.getClone();
    }

    @Nullable
    protected final ICommonsList<String> getRequestValuesWithoutDefault() {
        return RequestFieldDataMultiValue.getParams().getAsStringList(this.getFieldName(), null);
    }

    @Nonnull
    public final ICommonsList<String> getRequestValues() {
        return RequestFieldDataMultiValue.getParams().getAsStringList(this.getFieldName(), this.getDefaultValues());
    }

    public final boolean hasRequestValues(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, (String)"ExpectedValues");
        return CollectionEqualsHelper.equalsCollection(collection, this.getRequestValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldDataMultiValue requestFieldDataMultiValue = (RequestFieldDataMultiValue)object;
        return this.m_aDefaultValues.equals(requestFieldDataMultiValue.m_aDefaultValues);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aDefaultValues).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("DefaultValues", this.m_aDefaultValues).getToString();
    }
}

