/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler.specific;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.url.ISimpleURL;
import com.helger.url.URLBuilder;
import com.helger.url.data.IURLData;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectAbsoluteXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectAbsoluteXServletHandler.class);
    private final ISimpleURL m_aTargetURL;

    public RedirectAbsoluteXServletHandler(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"TargetURL");
        this.m_aTargetURL = iSimpleURL;
    }

    @Nonnull
    @Nonempty
    public final ISimpleURL getTargetURL() {
        return this.m_aTargetURL;
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        URLBuilder uRLBuilder = URLBuilder.of((IURLData)this.m_aTargetURL);
        for (Map.Entry entry : iRequestWebScopeWithoutResponse.params().entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                uRLBuilder.addParam(string, (String)v);
                continue;
            }
            if (!(v instanceof String[])) continue;
            for (String string2 : (String[])v) {
                uRLBuilder.addParam(string, string2);
            }
        }
        String string = uRLBuilder.build().getAsString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending redirect to '" + (String)string + "'");
        }
        unifiedResponse.setRedirect(string);
    }
}

