/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.TrackedRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingParallelRunningRequestCallback
implements IParallelRunningRequestCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingParallelRunningRequestCallback.class);
    private IErrorLevel m_aErrorLevel;

    public LoggingParallelRunningRequestCallback() {
        this((IErrorLevel)EErrorLevel.WARN);
    }

    public LoggingParallelRunningRequestCallback(@Nonnull IErrorLevel iErrorLevel) {
        this.setErrorLevel(iErrorLevel);
    }

    @Nonnull
    public final IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public final LoggingParallelRunningRequestCallback setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        return this;
    }

    @Override
    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, (String)("Currently " + n + " parallel requests are active!"));
    }

    @Override
    public void onParallelRunningRequestsBelowLimit() {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, (String)"Parallel requests are back to normal!");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("errorLevel", (Object)this.m_aErrorLevel).getToString();
    }
}

