/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xsds.bdxr.smp2;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.helper.CollectionEqualsHelper;
import com.helger.xsds.bdxr.smp2.ac.ServiceReferenceType;
import com.helger.xsds.bdxr.smp2.bc.ParticipantIDType;
import com.helger.xsds.bdxr.smp2.bc.SMPVersionIDType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import com.helger.xsds.xmldsig.SignatureType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ServiceGroupType", propOrder={"smpExtensions", "smpVersionID", "participantID", "serviceReference", "signature"})
@CodingStyleguideUnaware
public class ServiceGroupType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="SMPExtensions", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name="SMPVersionID", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required=true)
    private SMPVersionIDType smpVersionID;
    @XmlElement(name="ParticipantID", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required=true)
    private ParticipantIDType participantID;
    @XmlElement(name="ServiceReference", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/AggregateComponents")
    private List<ServiceReferenceType> serviceReference;
    @XmlElement(name="Signature", namespace="http://www.w3.org/2000/09/xmldsig#")
    private List<SignatureType> signature;

    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return this.smpExtensions;
    }

    public void setSMPExtensions(@Nullable SMPExtensionsType sMPExtensionsType) {
        this.smpExtensions = sMPExtensionsType;
    }

    @Nullable
    public SMPVersionIDType getSMPVersionID() {
        return this.smpVersionID;
    }

    public void setSMPVersionID(@Nullable SMPVersionIDType sMPVersionIDType) {
        this.smpVersionID = sMPVersionIDType;
    }

    @Nullable
    public ParticipantIDType getParticipantID() {
        return this.participantID;
    }

    public void setParticipantID(@Nullable ParticipantIDType participantIDType) {
        this.participantID = participantIDType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ServiceReferenceType> getServiceReference() {
        if (this.serviceReference == null) {
            this.serviceReference = new ArrayList<ServiceReferenceType>();
        }
        return this.serviceReference;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<SignatureType> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<SignatureType>();
        }
        return this.signature;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ServiceGroupType serviceGroupType = (ServiceGroupType)object;
        if (!EqualsHelper.equals((Object)this.participantID, (Object)serviceGroupType.participantID)) {
            return false;
        }
        if (!CollectionEqualsHelper.equalsCollection(this.serviceReference, serviceGroupType.serviceReference)) {
            return false;
        }
        if (!CollectionEqualsHelper.equalsCollection(this.signature, serviceGroupType.signature)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.smpExtensions, (Object)serviceGroupType.smpExtensions)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.smpVersionID, (Object)serviceGroupType.smpVersionID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.participantID).append(this.serviceReference).append(this.signature).append((Object)this.smpExtensions).append((Object)this.smpVersionID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ParticipantID", (Object)this.participantID).append("ServiceReference", this.serviceReference).append("Signature", this.signature).append("SmpExtensions", (Object)this.smpExtensions).append("SmpVersionID", (Object)this.smpVersionID).getToString();
    }

    public void setServiceReference(@Nullable List<ServiceReferenceType> list) {
        this.serviceReference = list;
    }

    public void setSignature(@Nullable List<SignatureType> list) {
        this.signature = list;
    }

    public boolean hasServiceReferenceEntries() {
        return !this.getServiceReference().isEmpty();
    }

    public boolean hasNoServiceReferenceEntries() {
        return this.getServiceReference().isEmpty();
    }

    @Nonnegative
    public int getServiceReferenceCount() {
        return this.getServiceReference().size();
    }

    @Nullable
    public ServiceReferenceType getServiceReferenceAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getServiceReference().get(n);
    }

    public void addServiceReference(@Nonnull ServiceReferenceType serviceReferenceType) {
        this.getServiceReference().add(serviceReferenceType);
    }

    public boolean hasSignatureEntries() {
        return !this.getSignature().isEmpty();
    }

    public boolean hasNoSignatureEntries() {
        return this.getSignature().isEmpty();
    }

    @Nonnegative
    public int getSignatureCount() {
        return this.getSignature().size();
    }

    @Nullable
    public SignatureType getSignatureAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getSignature().get(n);
    }

    public void addSignature(@Nonnull SignatureType signatureType) {
        this.getSignature().add(signatureType);
    }

    public void cloneTo(@Nonnull ServiceGroupType serviceGroupType) {
        ArrayList<ServiceReferenceType> arrayList;
        ParticipantIDType participantIDType = serviceGroupType.participantID = this.participantID == null ? null : this.participantID.clone();
        if (this.serviceReference == null) {
            serviceGroupType.serviceReference = null;
        } else {
            arrayList = new ArrayList<ServiceReferenceType>();
            for (ServiceReferenceType serviceReferenceType : this.getServiceReference()) {
                arrayList.add(serviceReferenceType == null ? null : serviceReferenceType.clone());
            }
            serviceGroupType.serviceReference = arrayList;
        }
        if (this.signature == null) {
            serviceGroupType.signature = null;
        } else {
            arrayList = new ArrayList();
            for (SignatureType signatureType : this.getSignature()) {
                arrayList.add((ServiceReferenceType)(signatureType == null ? null : signatureType.clone()));
            }
            serviceGroupType.signature = arrayList;
        }
        serviceGroupType.smpExtensions = this.smpExtensions == null ? null : this.smpExtensions.clone();
        serviceGroupType.smpVersionID = this.smpVersionID == null ? null : this.smpVersionID.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ServiceGroupType clone() {
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        this.cloneTo(serviceGroupType);
        return serviceGroupType;
    }

    @Nonnull
    public SMPVersionIDType setSMPVersionID(@Nullable String string) {
        SMPVersionIDType sMPVersionIDType = this.getSMPVersionID();
        if (sMPVersionIDType == null) {
            sMPVersionIDType = new SMPVersionIDType(string);
            this.setSMPVersionID(sMPVersionIDType);
        } else {
            sMPVersionIDType.setValue(string);
        }
        return sMPVersionIDType;
    }

    @Nonnull
    public ParticipantIDType setParticipantID(@Nullable String string) {
        ParticipantIDType participantIDType = this.getParticipantID();
        if (participantIDType == null) {
            participantIDType = new ParticipantIDType(string);
            this.setParticipantID(participantIDType);
        } else {
            participantIDType.setValue(string);
        }
        return participantIDType;
    }

    @Nullable
    public String getSMPVersionIDValue() {
        SMPVersionIDType sMPVersionIDType = this.getSMPVersionID();
        return sMPVersionIDType == null ? null : sMPVersionIDType.getValue();
    }

    @Nullable
    public String getParticipantIDValue() {
        ParticipantIDType participantIDType = this.getParticipantID();
        return participantIDType == null ? null : participantIDType.getValue();
    }
}

