/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xsds.bdxr.smp2.ac;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.helper.CollectionEqualsHelper;
import com.helger.xsds.bdxr.smp2.ac.CertificateType;
import com.helger.xsds.bdxr.smp2.bc.PublisherURIType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RedirectType", propOrder={"smpExtensions", "publisherURI", "certificate"})
@CodingStyleguideUnaware
public class RedirectType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="SMPExtensions", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name="PublisherURI", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required=true)
    private PublisherURIType publisherURI;
    @XmlElement(name="Certificate")
    private List<CertificateType> certificate;

    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return this.smpExtensions;
    }

    public void setSMPExtensions(@Nullable SMPExtensionsType sMPExtensionsType) {
        this.smpExtensions = sMPExtensionsType;
    }

    @Nullable
    public PublisherURIType getPublisherURI() {
        return this.publisherURI;
    }

    public void setPublisherURI(@Nullable PublisherURIType publisherURIType) {
        this.publisherURI = publisherURIType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<CertificateType> getCertificate() {
        if (this.certificate == null) {
            this.certificate = new ArrayList<CertificateType>();
        }
        return this.certificate;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RedirectType redirectType = (RedirectType)object;
        if (!CollectionEqualsHelper.equalsCollection(this.certificate, redirectType.certificate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.publisherURI, (Object)redirectType.publisherURI)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.smpExtensions, (Object)redirectType.smpExtensions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.certificate).append((Object)this.publisherURI).append((Object)this.smpExtensions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Certificate", this.certificate).append("PublisherURI", (Object)this.publisherURI).append("SmpExtensions", (Object)this.smpExtensions).getToString();
    }

    public void setCertificate(@Nullable List<CertificateType> list) {
        this.certificate = list;
    }

    public boolean hasCertificateEntries() {
        return !this.getCertificate().isEmpty();
    }

    public boolean hasNoCertificateEntries() {
        return this.getCertificate().isEmpty();
    }

    @Nonnegative
    public int getCertificateCount() {
        return this.getCertificate().size();
    }

    @Nullable
    public CertificateType getCertificateAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getCertificate().get(n);
    }

    public void addCertificate(@Nonnull CertificateType certificateType) {
        this.getCertificate().add(certificateType);
    }

    public void cloneTo(@Nonnull RedirectType redirectType) {
        if (this.certificate == null) {
            redirectType.certificate = null;
        } else {
            ArrayList<CertificateType> arrayList = new ArrayList<CertificateType>();
            for (CertificateType certificateType : this.getCertificate()) {
                arrayList.add(certificateType == null ? null : certificateType.clone());
            }
            redirectType.certificate = arrayList;
        }
        redirectType.publisherURI = this.publisherURI == null ? null : this.publisherURI.clone();
        redirectType.smpExtensions = this.smpExtensions == null ? null : this.smpExtensions.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public RedirectType clone() {
        RedirectType redirectType = new RedirectType();
        this.cloneTo(redirectType);
        return redirectType;
    }

    @Nonnull
    public PublisherURIType setPublisherURI(@Nullable String string) {
        PublisherURIType publisherURIType = this.getPublisherURI();
        if (publisherURIType == null) {
            publisherURIType = new PublisherURIType(string);
            this.setPublisherURI(publisherURIType);
        } else {
            publisherURIType.setValue(string);
        }
        return publisherURIType;
    }

    @Nullable
    public String getPublisherURIValue() {
        PublisherURIType publisherURIType = this.getPublisherURI();
        return publisherURIType == null ? null : publisherURIType.getValue();
    }
}

