/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.holdenkarau.spark.testing.DataFrameSuiteBase;
import com.holdenkarau.spark.testing.DataFrameSuiteBase$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Assertions;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class DataFrameSuiteBase$class {
    public static HiveContext sqlContext(DataFrameSuiteBase $this) {
        return $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$$_sqlContext();
    }

    public static void beforeAll(DataFrameSuiteBase $this) {
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$$super$beforeAll();
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$$_sqlContext_$eq(new HiveContext($this.sc()));
    }

    public static void afterAll(DataFrameSuiteBase $this) {
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$$super$afterAll();
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$$_sqlContext_$eq(null);
    }

    public static void equalDataFrames(DataFrameSuiteBase $this, DataFrame expected, DataFrame result) {
        $this.equalSchema(expected.schema(), result.schema());
        expected.rdd().cache();
        result.rdd().cache();
        RDD expectedRDD = DataFrameSuiteBase$class.zipWithIndex($this, expected.rdd());
        RDD resultRDD = DataFrameSuiteBase$class.zipWithIndex($this, result.rdd());
        long $org_scalatest_assert_macro_left = expectedRDD.count();
        long $org_scalatest_assert_macro_right = resultRDD.count();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Tuple2[] unequal = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(expectedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).cogroup(resultRDD).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Tuple2<Iterable<Row>, Iterable<Row>>> x0$1) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Iterable<Row>, Iterable<Row>>> tuple22 = x0$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Iterable r1 = (Iterable)tuple2._1();
                    Iterable r2 = (Iterable)tuple2._2();
                    boolean bl = !r1.isEmpty() && !r2.isEmpty() && !((Row)r1.head()).equals(r2.head()) && !DataFrameSuiteBase$.MODULE$.approxEquals((Row)r1.head(), (Row)r2.head(), 0.0);
                    return bl;
                }
                throw new MatchError(tuple22);
            }
        }).take($this.maxCount());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = ((TripleEquals)$this).convertToEqualizer((Object)unequal);
        Nil$ $org_scalatest_assert_macro_right2 = Nil$.MODULE$;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        expected.rdd().unpersist(expected.rdd().unpersist$default$1());
        result.rdd().unpersist(result.rdd().unpersist$default$1());
    }

    private static RDD zipWithIndex(DataFrameSuiteBase $this, RDD input) {
        int[] counts = (int[])input.mapPartitions((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterator<Object> apply(Iterator<Object> itr) {
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()}));
            }
        }, input.mapPartitions$default$2(), ClassTag$.MODULE$.Int()).collect();
        Map countSums = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(counts).scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, int x$2) {
                return this.apply$mcIII$sp(x$1, x$2);
            }

            public int apply$mcIII$sp(int x$1, int x$2) {
                return x$1 + x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    int y = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(y, x);
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        return input.mapPartitionsWithIndex((Function2)new Serializable($this, countSums){
            public static final long serialVersionUID = 0L;
            public final Map countSums$1;

            public final Iterator<Tuple2<Object, Object>> apply(int x0$3, Iterator<Object> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), x1$1);
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Iterator itr = (Iterator)tuple2._2();
                    Iterator iterator = itr.zipWithIndex().map((Function1)new Serializable(this, idx){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DataFrameSuiteBase$.anonfun.zipWithIndex.1 $outer;
                        private final int idx$1;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$4) {
                            Tuple2<Object, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                Object y = tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(i + BoxesRunTime.unboxToInt((Object)this.$outer.countSums$1.apply((Object)BoxesRunTime.boxToInteger((int)this.idx$1))))), y);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.idx$1 = idx$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.countSums$1 = countSums$1;
            }
        }, input.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static void approxEqualDataFrames(DataFrameSuiteBase $this, DataFrame expected, DataFrame result, double tol) {
        $this.equalSchema(expected.schema(), result.schema());
        expected.rdd().cache();
        result.rdd().cache();
        RDD expectedRDD = DataFrameSuiteBase$class.zipWithIndex($this, expected.rdd());
        RDD resultRDD = DataFrameSuiteBase$class.zipWithIndex($this, result.rdd());
        RDD cogrouped = RDD$.MODULE$.rddToPairRDDFunctions(expectedRDD, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Int$.MODULE$).cogroup(resultRDD);
        Tuple2[] unequal = (Tuple2[])cogrouped.filter((Function1)new Serializable($this, tol){
            public static final long serialVersionUID = 0L;
            private final double tol$1;

            public final boolean apply(Tuple2<Object, Tuple2<Iterable<Row>, Iterable<Row>>> x0$5) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Iterable<Row>, Iterable<Row>>> tuple22 = x0$5;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    Iterable r1 = (Iterable)tuple2._1();
                    Iterable r2 = (Iterable)tuple2._2();
                    boolean bl = r1.isEmpty() || r2.isEmpty() || !DataFrameSuiteBase$.MODULE$.approxEquals((Row)r1.head(), (Row)r2.head(), this.tol$1);
                    return bl;
                }
                throw new MatchError(tuple22);
            }
            {
                this.tol$1 = tol$1;
            }
        }).take($this.maxCount());
        expected.rdd().unpersist(expected.rdd().unpersist$default$1());
        result.rdd().unpersist(result.rdd().unpersist$default$1());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)unequal);
        Nil$ $org_scalatest_assert_macro_right = Nil$.MODULE$;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public static void equalSchema(DataFrameSuiteBase $this, StructType expected, StructType result) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)expected.treeString());
        String $org_scalatest_assert_macro_right = result.treeString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public static void $init$(DataFrameSuiteBase $this) {
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBase$_setter_$maxCount_$eq(10);
    }
}

