/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import com.holdenkarau.spark.testing.Utils$;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.DefaultEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.KafkaTestUtils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\u0001\u0003\u00015\u0011abS1gW\u0006$Vm\u001d;Vi&d7O\u0003\u0002\u0004\t\u0005)1.\u00194lC*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!a\u0002'pO\u001eLgn\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013%q$\u0001\u0004{W\"{7\u000f^\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB*ue&tw\r\u0003\u0004*\u0001\u0001\u0006I\u0001I\u0001\bu.Dun\u001d;!\u0011\u001dY\u0003\u00011A\u0005\n1\naA_6Q_J$X#A\u0017\u0011\u0005=q\u0013BA\u0018\u0011\u0005\rIe\u000e\u001e\u0005\bc\u0001\u0001\r\u0011\"\u00033\u0003)Q8\u000eU8si~#S-\u001d\u000b\u0003gY\u0002\"a\u0004\u001b\n\u0005U\u0002\"\u0001B+oSRDqa\u000e\u0019\u0002\u0002\u0003\u0007Q&A\u0002yIEBa!\u000f\u0001!B\u0013i\u0013a\u0002>l!>\u0014H\u000f\t\u0005\bw\u0001\u0011\r\u0011\"\u0003-\u0003MQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;u\u0011\u0019i\u0004\u0001)A\u0005[\u0005!\"p[\"p]:,7\r^5p]RKW.Z8vi\u0002Bqa\u0010\u0001C\u0002\u0013%A&\u0001\t{WN+7o]5p]RKW.Z8vi\"1\u0011\t\u0001Q\u0001\n5\n\u0011C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011%\u0019\u0005\u00011AA\u0002\u0013%A)A\u0005{_>\\W-\u001a9feV\tQ\t\u0005\u0002G\u000f6\t\u0001A\u0002\u0003I\u0001\u0011I%!E#nE\u0016$G-\u001a3[_>\\W-\u001a9feN\u0011qI\u0004\u0005\t\u0017\u001e\u0013)\u0019!C\u0001\u0019\u0006I!p[\"p]:,7\r^\u000b\u0002\u001bB\u0011a*\u0015\b\u0003\u001f=K!\u0001\u0015\t\u0002\rA\u0013X\rZ3g\u0013\t9#K\u0003\u0002Q!!AAk\u0012B\u0001B\u0003%Q*\u0001\u0006{W\u000e{gN\\3di\u0002BQ!G$\u0005\u0002Y#\"!R,\t\u000b-+\u0006\u0019A'\t\u000fe;%\u0019!C\u00015\u0006Y1O\\1qg\"|G\u000fR5s+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010%\u0003\tIw.\u0003\u0002a;\n!a)\u001b7f\u0011\u0019\u0011w\t)A\u00057\u0006a1O\\1qg\"|G\u000fR5sA!9Am\u0012b\u0001\n\u0003Q\u0016A\u00027pO\u0012K'\u000f\u0003\u0004g\u000f\u0002\u0006IaW\u0001\bY><G)\u001b:!\u0011\u001d\u0019uI1A\u0005\u0002!,\u0012!\u001b\t\u0003U:l\u0011a\u001b\u0006\u0003Y6\faa]3sm\u0016\u0014(BA\"\t\u0013\ty7NA\b[_>\\U-\u001a9feN+'O^3s\u0011\u0019\tx\t)A\u0005S\u0006Q!p\\8lK\u0016\u0004XM\u001d\u0011\t\u000f]:\u0015\u0011)A\u0005gB!q\u0002\u001e\u0011.\u0013\t)\bC\u0001\u0004UkBdWM\r\u0005\bo\u001e\u0013\r\u0011\"\u0001 \u0003\tI\u0007\u000f\u0003\u0004z\u000f\u0002\u0006I\u0001I\u0001\u0004SB\u0004\u0003bB>H\u0005\u0004%\t\u0001L\u0001\u0005a>\u0014H\u000f\u0003\u0004~\u000f\u0002\u0006I!L\u0001\u0006a>\u0014H\u000f\t\u0005\t\u007f\u001e\u0013\r\u0011\"\u0001\u0002\u0002\u00059a-Y2u_JLXCAA\u0002!\rQ\u0017QA\u0005\u0004\u0003\u000fY'\u0001\u0006(J\u001fN+'O^3s\u0007:DhNR1di>\u0014\u0018\u0010\u0003\u0005\u0002\f\u001d\u0003\u000b\u0011BA\u0002\u0003!1\u0017m\u0019;pef\u0004\u0003\u0002CA\b\u000f\n\u0007I\u0011\u0001\u0017\u0002\u0015\u0005\u001cG/^1m!>\u0014H\u000fC\u0004\u0002\u0014\u001d\u0003\u000b\u0011B\u0017\u0002\u0017\u0005\u001cG/^1m!>\u0014H\u000f\t\u0005\b\u0003/9E\u0011AA\r\u0003!\u0019\b.\u001e;e_^tG#A\u001a\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011qD\u0001\u000eu>|7.Z3qKJ|F%Z9\u0015\u0007M\n\t\u0003\u0003\u00058\u00037\t\t\u00111\u0001F\u0011\u0019\t\b\u0001)Q\u0005\u000b\"Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0003!Q8n\u00117jK:$XCAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t\u0001B_6dY&,g\u000e\u001e\u0006\u0004\u0003kQ\u0011AB%1\u0013R,7-\u0003\u0003\u0002:\u0005=\"\u0001\u0003.l\u00072LWM\u001c;\t\u0017\u0005u\u0002\u00011AA\u0002\u0013%\u0011qH\u0001\ru.\u001cE.[3oi~#S-\u001d\u000b\u0004g\u0005\u0005\u0003\"C\u001c\u0002<\u0005\u0005\t\u0019AA\u0016\u0011!\t)\u0005\u0001Q!\n\u0005-\u0012!\u0003>l\u00072LWM\u001c;!\u0011!\tI\u0005\u0001b\u0001\n\u0013y\u0012A\u00032s_.,'\u000fS8ti\"9\u0011Q\n\u0001!\u0002\u0013\u0001\u0013a\u00032s_.,'\u000fS8ti\u0002B\u0001\"!\u0015\u0001\u0001\u0004%I\u0001L\u0001\u000bEJ|7.\u001a:Q_J$\b\"CA+\u0001\u0001\u0007I\u0011BA,\u00039\u0011'o\\6feB{'\u000f^0%KF$2aMA-\u0011!9\u00141KA\u0001\u0002\u0004i\u0003bBA/\u0001\u0001\u0006K!L\u0001\fEJ|7.\u001a:Q_J$\b\u0005C\u0006\u0002b\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0014A\u00032s_.,'oQ8oMV\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019A.a\u001b\u000b\u0003\rIA!a\u001c\u0002j\tY1*\u00194lC\u000e{gNZ5h\u0011-\t\u0019\b\u0001a\u0001\u0002\u0004%I!!\u001e\u0002\u001d\t\u0014xn[3s\u0007>tgm\u0018\u0013fcR\u00191'a\u001e\t\u0013]\n\t(!AA\u0002\u0005\u0015\u0004\u0002CA>\u0001\u0001\u0006K!!\u001a\u0002\u0017\t\u0014xn[3s\u0007>tg\r\t\u0005\u000bY\u0002\u0001\r\u00111A\u0005\n\u0005}TCAAA!\u0011\t9'a!\n\t\u0005\u0015\u0015\u0011\u000e\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0006\u0002\n\u0002\u0001\r\u00111A\u0005\n\u0005-\u0015AC:feZ,'o\u0018\u0013fcR\u00191'!$\t\u0013]\n9)!AA\u0002\u0005\u0005\u0005\u0002CAI\u0001\u0001\u0006K!!!\u0002\u000fM,'O^3sA!Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011BAL\u0003!\u0001(o\u001c3vG\u0016\u0014XCAAM!!\tY*a(\u0002$\u0006\rVBAAO\u0015\u0011\t)*a\u001b\n\t\u0005\u0005\u0016Q\u0014\u0002\t!J|G-^2feB)q\"!*\u0002*&\u0019\u0011q\u0015\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\tY+C\u0002\u0002.B\u0011AAQ=uK\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0007I\u0011BAZ\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\r\u0019\u0014Q\u0017\u0005\no\u0005=\u0016\u0011!a\u0001\u00033C\u0001\"!/\u0001A\u0003&\u0011\u0011T\u0001\naJ|G-^2fe\u0002B\u0011\"!0\u0001\u0001\u0004%I!a0\u0002\u000fi\\'+Z1esV\u0011\u0011\u0011\u0019\t\u0004\u001f\u0005\r\u0017bAAc!\t9!i\\8mK\u0006t\u0007\"CAe\u0001\u0001\u0007I\u0011BAf\u0003-Q8NU3bIf|F%Z9\u0015\u0007M\ni\rC\u00058\u0003\u000f\f\t\u00111\u0001\u0002B\"A\u0011\u0011\u001b\u0001!B\u0013\t\t-\u0001\u0005{WJ+\u0017\rZ=!\u0011%\t)\u000e\u0001a\u0001\n\u0013\ty,A\u0006ce>\\WM\u001d*fC\u0012L\b\"CAm\u0001\u0001\u0007I\u0011BAn\u0003=\u0011'o\\6feJ+\u0017\rZ=`I\u0015\fHcA\u001a\u0002^\"Iq'a6\u0002\u0002\u0003\u0007\u0011\u0011\u0019\u0005\t\u0003C\u0004\u0001\u0015)\u0003\u0002B\u0006a!M]8lKJ\u0014V-\u00193zA!1\u0011Q\u001d\u0001\u0005\u00021\u000b\u0011B_6BI\u0012\u0014Xm]:\t\r\u0005%\b\u0001\"\u0001M\u00035\u0011'o\\6fe\u0006#GM]3tg\"9\u0011Q\u001e\u0001\u0005\u0002\u0005%\u0012a\u0004>p_.,W\r]3s\u00072LWM\u001c;\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006\u0019\"M]8lKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\u0011\u0011Q\u001f\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111 \u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\fIP\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa\u0001\u0001\t\u0013\t\u00190A\u000bqe>$WoY3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\t\u001d\u0001\u0001\"\u0003\u0002\u001a\u000512/\u001a;va\u0016k'-\u001a3eK\u0012Tvn\\6fKB,'\u000fC\u0004\u0003\f\u0001!IA!\u0004\u0002;]\f\u0017\u000e^+oi&dW*\u001a;bI\u0006$\u0018-S:Qe>\u0004\u0018mZ1uK\u0012$Ra\rB\b\u0005'AqA!\u0005\u0003\n\u0001\u0007Q*A\u0003u_BL7\rC\u0004\u0003\u0016\t%\u0001\u0019A\u0017\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002B\r\u0001\u0011%\u0011\u0011D\u0001\u0019g\u0016$X\u000f]#nE\u0016$G-\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002B\u000f\u0001\u0011\u0005\u0011\u0011D\u0001\u0006g\u0016$X\u000f\u001d\u0005\b\u0005C\u0001A\u0011AA\r\u0003!!X-\u0019:e_^t\u0007b\u0002B\u0013\u0001\u0011\u0005!qE\u0001\fGJ,\u0017\r^3U_BL7\rF\u00024\u0005SAqA!\u0005\u0003$\u0001\u0007Q\nC\u0004\u0003.\u0001!\tAa\f\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u000bM\u0012\tDa\r\t\u000f\tE!1\u0006a\u0001\u001b\"A!Q\u0007B\u0016\u0001\u0004\t\u0019+A\u0004nKN\u001c\u0018mZ3\t\u000f\te\u0002\u0001\"\u0001\u0003<\u0005QQM^3oiV\fG\u000e\\=\u0016\t\tu\"Q\t\u000b\u0007\u0005\u007f\u0011\tG!\u001c\u0015\t\t\u0005#q\u000b\t\u0005\u0005\u0007\u0012)\u0005\u0004\u0001\u0005\u0011\t\u001d#q\u0007b\u0001\u0005\u0013\u0012\u0011\u0001V\t\u0005\u0005\u0017\u0012\t\u0006E\u0002\u0010\u0005\u001bJ1Aa\u0014\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u0004B*\u0013\r\u0011)\u0006\u0005\u0002\u0004\u0003:L\b\"\u0003B-\u0005o!\t\u0019\u0001B.\u0003\u00111WO\\2\u0011\u000b=\u0011iF!\u0011\n\u0007\t}\u0003C\u0001\u0005=Eft\u0017-\\3?\u0011!\u0011\u0019Ga\u000eA\u0002\t\u0015\u0014a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0005O\u0012I'D\u0001\u0005\u0013\r\u0011Y\u0007\u0002\u0002\u0005)&lW\r\u0003\u0005\u0003p\t]\u0002\u0019\u0001B3\u0003!Ig\u000e^3sm\u0006d\u0007")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    private Producer<byte[], byte[]> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server = x$1;
    }

    private Producer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", DefaultEncoder.class.getName());
        return var1_1;
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(new ZkClient(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), (ZkSerializer)ZKStringSerializer$.MODULE$));
        this.zkReady_$eq(true);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$1;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(this.topic$1, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        });
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().startup();
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)port));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(null);
        }
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic) {
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        this.waitUntilMetadataIsPropagated(topic, 0);
    }

    public void sendMessages(String topic, byte[] message) {
        this.producer_$eq((Producer<byte[], byte[]>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)message)}));
        this.producer().close();
        this.producer_$eq(null);
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public final boolean org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(String topic$1, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$1, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic$1, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().nonEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 6000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = 9092;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final Tuple2<String, Object> x$1;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.zookeeper().shutdown();
            this.factory().shutdown();
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$1 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$1._1();
                this.port = this.x$1._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

