/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import com.igormaznitsa.meta.annotation.LazyInited;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.annotation.ReturnsOriginal;
import com.igormaznitsa.meta.common.utils.ArrayUtils;
import com.igormaznitsa.meta.common.utils.Assertions;
import com.igormaznitsa.meta.common.utils.GetUtils;
import com.igormaznitsa.meta.common.utils.StrUtils;
import com.igormaznitsa.mvngolang.utils.ProxySettings;
import com.igormaznitsa.mvngolang.utils.UnpackUtils;
import com.igormaznitsa.mvngolang.utils.WildCardMatcher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public abstract class AbstractGolangMojo
extends AbstractMojo {
    public static final String NAME_PATTERN = "go%s.%s-%s%s";
    private static final List<String> ALLOWED_SDKARCHIVE_CONTENT_TYPE = Collections.unmodifiableList(Arrays.asList("application/octet-stream", "application/zip", "application/x-tar", "application/x-gzip"));
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final String[] BANNER = new String[]{"______  ___             _________     ______", "___   |/  /__   __________  ____/________  / ______ ______________ _", "__  /|_/ /__ | / /_  __ \\  / __ _  __ \\_  /  _  __ `/_  __ \\_  __ `/", "_  /  / / __ |/ /_  / / / /_/ / / /_/ /  /___/ /_/ /_  / / /  /_/ / ", "/_/  /_/  _____/ /_/ /_/\\____/  \\____//_____/\\__,_/ /_/ /_/_\\__, /", "                                                           /____/", "                  https://github.com/raydac/mvn-golang", ""};
    protected final Set<String> buildFlagsToIgnore = new HashSet<String>();
    protected final List<String> tempBuildFlags = new ArrayList<String>();
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="useMavenProxy", defaultValue="false")
    private boolean useMavenProxy;
    @Parameter(name="supposeSdkArchiveFileName", defaultValue="true")
    private boolean supposeSdkArchiveFileName;
    @Parameter(name="proxy")
    private ProxySettings proxy;
    @Parameter(name="skip", defaultValue="false")
    private boolean skip;
    @Parameter(name="ignoreErrorExitCode", defaultValue="false")
    private boolean ignoreErrorExitCode;
    @Parameter(name="reportsFolder", defaultValue="${project.build.directory}${file.separator}reports")
    private String reportsFolder;
    @Parameter(name="outLogFile")
    private String outLogFile;
    @Parameter(name="errLogFile")
    private String errLogFile;
    @Parameter(name="sdkSite", defaultValue="https://storage.googleapis.com/golang/")
    private String sdkSite;
    @Parameter(defaultValue="true", name="hideBanner")
    private boolean hideBanner;
    @Parameter(defaultValue="${user.home}${file.separator}.mvnGoLang", name="storeFolder")
    private String storeFolder;
    @Parameter(defaultValue="${user.home}${file.separator}.mvnGoLang${file.separator}.go_path", name="goPath")
    private String goPath;
    @Parameter(name="targetArm")
    private String targetArm;
    @Parameter(defaultValue="${project.build.directory}", name="goBin")
    private String goBin;
    @Parameter(name="goVersion", required=true)
    private String goVersion;
    @Parameter(name="goRoot")
    private String goRoot;
    @Parameter(name="goRootBootstrap")
    private String goRootBootstrap;
    @Parameter(name="enforceGoPathToEnd", defaultValue="false")
    private boolean enforceGoPathToEnd;
    @Parameter(name="execSubpath", defaultValue="bin")
    private String execSubpath;
    @Parameter(name="exec", defaultValue="go")
    private String exec;
    @Parameter(name="echoWarn")
    private String[] echoWarn;
    @Parameter(name="echo")
    private String[] echo;
    @Parameter(name="disableSdkLoad", defaultValue="false")
    private boolean disableSdkLoad;
    @Parameter(defaultValue="${project.build.sourceDirectory}", name="sources")
    private String sources;
    @Parameter(name="targetOs")
    private String targetOs;
    @Parameter(name="os")
    private String os;
    @Parameter(name="targetArch")
    private String targetArch;
    @Parameter(name="arch")
    private String arch;
    @Parameter(name="osxVersion")
    private String osxVersion;
    @Parameter(name="buildFlags")
    private String[] buildFlags;
    @Parameter(name="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(name="keepSdkArchive", defaultValue="false")
    private boolean keepSdkArchive;
    @Parameter(name="useGoTool")
    private String useGoTool;
    @Parameter(name="useEnvVars", defaultValue="false")
    private boolean useEnvVars;
    @Parameter(name="env")
    private Map<?, ?> env;
    @Parameter(name="sdkArchiveName")
    private String sdkArchiveName;
    @Parameter(name="sdkDownloadUrl")
    private String sdkDownloadUrl;
    @Parameter(name="keepUnarchFolderIfError", defaultValue="false")
    private boolean keepUnarchFolderIfError;
    @Parameter(name="addToGoPath")
    private String[] addToGoPath;
    @LazyInited
    private CloseableHttpClient httpClient;
    @LazyInited
    private ByteArrayOutputStream consoleErrBuffer;
    @LazyInited
    private ByteArrayOutputStream consoleOutBuffer;

    @Nonnull
    private static String ensureNoSurroundingSlashes(@Nonnull String str) {
        String result = str;
        if (!(result.isEmpty() || result.charAt(0) != '/' && result.charAt(0) != '\\')) {
            result = result.substring(1);
        }
        if (!(result.isEmpty() || result.charAt(result.length() - 1) != '/' && result.charAt(result.length() - 1) != '\\')) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static void deleteFileIfExists(@Nonnull File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException("Can't delete file : " + file);
        }
    }

    private static boolean isSafeEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    @Nonnull
    private static String extractExtensionOfArchive(@Nonnull String archiveName) {
        String lcName = archiveName;
        String result = lcName.endsWith(".tar.gz") ? archiveName.substring(archiveName.length() - "tar.gz".length()) : FilenameUtils.getExtension((String)archiveName);
        return result;
    }

    @Nonnull
    private static String investigateArch() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        if (arch.contains("arm")) {
            return "arm";
        }
        if (arch.equals("386") || arch.equals("i386") || arch.equals("x86")) {
            return "386";
        }
        return "amd64";
    }

    @Nonnull
    protected static String adaptExecNameForOS(@Nonnull String execName) {
        return execName + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
    }

    @Nonnull
    private static String getPathToFolder(@Nonnull String path) {
        String text = path;
        if (!text.endsWith("/") && !text.endsWith("\\")) {
            text = text + File.separatorChar;
        }
        return text;
    }

    @Nonnull
    private static String getPathToFolder(@Nonnull File path) {
        return AbstractGolangMojo.getPathToFolder(path.getAbsolutePath());
    }

    @Nullable
    protected static File findExisting(File ... files) {
        File result = null;
        for (File f : files) {
            if (f == null || !f.isFile()) continue;
            result = f;
            break;
        }
        return result;
    }

    @Nonnull
    private static String removeSrcFolderAtEndIfPresented(@Nonnull String text) {
        String result = text;
        if (text.endsWith("/src") || text.endsWith("\\src")) {
            result = text.substring(0, text.length() - 4);
        }
        return result;
    }

    @Nonnull
    private static String preparePath(String ... paths) {
        StringBuilder result = new StringBuilder();
        HashSet<String> alreadyAdded = new HashSet<String>();
        for (String s : paths) {
            if (s == null || s.isEmpty() || alreadyAdded.contains(s)) continue;
            if (result.length() > 0) {
                result.append(SystemUtils.IS_OS_WINDOWS ? (char)';' : ':');
            }
            result.append(s);
            alreadyAdded.add(s);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static synchronized File loadSDKAndUnpackIntoCache(@Nonnull AbstractGolangMojo instance, @Nullable ProxySettings proxySettings, @Nonnull File cacheFolder, @Nonnull String baseSdkName, boolean dontLoadIfNotInCache) throws IOException {
        File sdkFolder = new File(cacheFolder, baseSdkName);
        File lockFile = new File(cacheFolder, ".lck_load_" + baseSdkName);
        lockFile.deleteOnExit();
        try {
            File file;
            String linkForDownloading;
            File archiveFile;
            if (!lockFile.createNewFile()) {
                instance.getLog().info((CharSequence)"Detected SDK loading, waiting for the process end");
                while (lockFile.exists()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        throw new IOException("Wait of SDK loading is interrupted", ex);
                    }
                }
                instance.getLog().info((CharSequence)"Loading process has been completed");
                File ex = sdkFolder;
                return ex;
            }
            if (sdkFolder.isDirectory()) {
                if (instance.verbose || instance.getLog().isDebugEnabled()) {
                    instance.getLog().info((CharSequence)("SDK cache folder : " + sdkFolder));
                }
                File ex = sdkFolder;
                return ex;
            }
            if (dontLoadIfNotInCache) {
                throw new IOException("Can't find " + baseSdkName + " in the cache but loading is directly disabled");
            }
            String predefinedLink = instance.getSdkDownloadUrl();
            if (AbstractGolangMojo.isSafeEmpty(predefinedLink)) {
                instance.logOptionally("There is not any predefined SDK URL");
                String sdkFileName = instance.findSdkArchiveFileName(proxySettings, baseSdkName);
                archiveFile = new File(cacheFolder, sdkFileName);
                linkForDownloading = instance.getSdkSite() + sdkFileName;
            } else {
                String extension = AbstractGolangMojo.extractExtensionOfArchive((String)Assertions.assertNotNull((Object)predefinedLink));
                archiveFile = new File(cacheFolder, baseSdkName + '.' + extension);
                linkForDownloading = predefinedLink;
                instance.logOptionally("Using predefined URL to download SDK : " + linkForDownloading);
                instance.logOptionally("Detected extension of archive : " + extension);
            }
            HttpGet methodGet = new HttpGet(linkForDownloading);
            RequestConfig config = instance.processRequestConfig(proxySettings, RequestConfig.custom()).build();
            methodGet.setConfig(config);
            boolean errorsDuringLoading = true;
            try {
                if (!archiveFile.isFile()) {
                    instance.getLog().warn((CharSequence)("Loading SDK archive with URL : " + linkForDownloading));
                    HttpResponse response = instance.getHttpClient(proxySettings).execute((HttpUriRequest)methodGet);
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() != 200) {
                        throw new IOException(String.format("Can't load SDK archive from %s : %d %s", linkForDownloading, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                    }
                    HttpEntity entity = response.getEntity();
                    Header contentType = entity.getContentType();
                    if (!ALLOWED_SDKARCHIVE_CONTENT_TYPE.contains(contentType.getValue())) {
                        throw new IOException("Unsupported content type : " + contentType.getValue());
                    }
                    InputStream inStream = entity.getContent();
                    instance.getLog().info((CharSequence)("Downloading SDK archive into file : " + archiveFile));
                    FileUtils.copyInputStreamToFile((InputStream)inStream, (File)archiveFile);
                    instance.getLog().info((CharSequence)("Archived SDK has been succesfully downloaded, its size is " + archiveFile.length() / 1024L + " Kb"));
                    inStream.close();
                } else {
                    instance.getLog().info((CharSequence)("Archive file of SDK has been found in the cache : " + archiveFile));
                }
                errorsDuringLoading = false;
                file = instance.unpackArchToFolder(archiveFile, "go", sdkFolder);
            }
            catch (Throwable throwable) {
                methodGet.releaseConnection();
                if (errorsDuringLoading || !instance.isKeepSdkArchive()) {
                    instance.logOptionally("Deleting archive : " + archiveFile + (errorsDuringLoading ? " (because error during loading)" : ""));
                    AbstractGolangMojo.deleteFileIfExists(archiveFile);
                } else {
                    instance.logOptionally("Archive file is kept for special flag : " + archiveFile);
                }
                throw throwable;
            }
            methodGet.releaseConnection();
            if (errorsDuringLoading || !instance.isKeepSdkArchive()) {
                instance.logOptionally("Deleting archive : " + archiveFile + (errorsDuringLoading ? " (because error during loading)" : ""));
                AbstractGolangMojo.deleteFileIfExists(archiveFile);
            } else {
                instance.logOptionally("Archive file is kept for special flag : " + archiveFile);
            }
            return file;
        }
        finally {
            FileUtils.deleteQuietly((File)lockFile);
        }
    }

    @Nullable
    public String getGoBin() {
        String foundInEnvironment = System.getenv("GOBIN");
        String result = (String)Assertions.assertNotNull((Object)this.goBin);
        if ("NONE".equals(result.trim())) {
            result = null;
        } else if (foundInEnvironment != null && this.isUseEnvVars()) {
            result = foundInEnvironment;
        }
        return result;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isEnforceGoPathToEnd() {
        return this.enforceGoPathToEnd;
    }

    @Nonnull
    public MavenProject getProject() {
        return this.project;
    }

    public boolean isIgnoreErrorExitCode() {
        return this.ignoreErrorExitCode;
    }

    @Nonnull
    public Map<?, ?> getEnv() {
        return (Map)GetUtils.ensureNonNull(this.env, (Object)Collections.EMPTY_MAP);
    }

    @Nullable
    public String getSdkDownloadUrl() {
        return this.sdkDownloadUrl;
    }

    @Nonnull
    public String getExecSubpath() {
        return AbstractGolangMojo.ensureNoSurroundingSlashes((String)Assertions.assertNotNull((Object)this.execSubpath));
    }

    @Nonnull
    public String getExec() {
        return AbstractGolangMojo.ensureNoSurroundingSlashes((String)Assertions.assertNotNull((Object)this.exec));
    }

    public boolean isUseEnvVars() {
        return this.useEnvVars;
    }

    public boolean isKeepSdkArchive() {
        return this.keepSdkArchive;
    }

    public boolean isKeepUnarchFolderIfError() {
        return this.keepUnarchFolderIfError;
    }

    @Nullable
    public String getSdkArchiveName() {
        return this.sdkArchiveName;
    }

    @Nonnull
    public String getReportsFolder() {
        return this.reportsFolder;
    }

    @Nullable
    public String getOutLogFile() {
        return this.outLogFile;
    }

    @Nullable
    public String getErrLogFile() {
        return this.errLogFile;
    }

    @Nonnull
    public String getStoreFolder() {
        return this.storeFolder;
    }

    @Nullable
    public String getUseGoTool() {
        return this.useGoTool;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDisableSdkLoad() {
        return this.disableSdkLoad;
    }

    @Nonnull
    public String getSdkSite() {
        return (String)Assertions.assertNotNull((Object)this.sdkSite);
    }

    @Nonnull
    @MustNotContainNull
    public String[] getBuildFlags() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : (String[])ArrayUtils.joinArrays((Object[][])new String[][]{(String[])GetUtils.ensureNonNull((Object)this.buildFlags, (Object)ArrayUtils.EMPTY_STRING_ARRAY), this.getExtraBuildFlags()})) {
            if (this.buildFlagsToIgnore.contains(s)) continue;
            result.add(s);
        }
        for (String b : this.tempBuildFlags) {
            result.add(b);
        }
        return result.toArray(new String[result.size()]);
    }

    @Nonnull
    @MustNotContainNull
    protected String[] getExtraBuildFlags() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public File findGoPath(boolean ensureExist) throws IOException {
        LOCKER.lock();
        try {
            String theGoPath = this.getGoPath();
            if (theGoPath.contains(File.pathSeparator)) {
                this.getLog().error((CharSequence)"Detected multiple folder items in the 'goPath' parameter but it must contain only folder!");
                throw new IOException("Detected multiple folder items in the 'goPath'");
            }
            File result = new File(theGoPath);
            if (ensureExist && !result.isDirectory() && !result.mkdirs()) {
                throw new IOException("Can't create folder : " + theGoPath);
            }
            File file = result;
            return file;
        }
        finally {
            LOCKER.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File findGoRootBootstrap(boolean ensureExist) throws IOException {
        LOCKER.lock();
        try {
            String value = this.getGoRootBootstrap();
            File result = null;
            if (value != null) {
                result = new File(value);
                if (ensureExist && !result.isDirectory()) {
                    throw new IOException("Can't find folder for GOROOT_BOOTSTRAP: " + result);
                }
            }
            File file = result;
            return file;
        }
        finally {
            LOCKER.unlock();
        }
    }

    @Nonnull
    public String getOs() {
        String result = this.os;
        if (AbstractGolangMojo.isSafeEmpty(result)) {
            result = SystemUtils.IS_OS_WINDOWS ? "windows" : (SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_FREE_BSD ? "freebsd" : "darwin"));
        }
        return result;
    }

    @Nonnull
    public String getArch() {
        String result = this.arch;
        if (AbstractGolangMojo.isSafeEmpty(result)) {
            result = AbstractGolangMojo.investigateArch();
        }
        return result;
    }

    @Nonnull
    public String getGoPath() {
        String foundInEnvironment = System.getenv("GOPATH");
        String result = (String)Assertions.assertNotNull((Object)this.goPath);
        if (foundInEnvironment != null && this.isUseEnvVars()) {
            result = foundInEnvironment;
        }
        return result;
    }

    @Nullable
    public String getTargetArm() {
        String result = this.targetArm;
        if (AbstractGolangMojo.isSafeEmpty(result) && this.isUseEnvVars()) {
            result = System.getenv("GOARM");
        }
        return result;
    }

    @Nullable
    public String getTargetOS() {
        String result = this.targetOs;
        if (AbstractGolangMojo.isSafeEmpty(result) && this.isUseEnvVars()) {
            result = System.getenv("GOOS");
        }
        return result;
    }

    @Nullable
    public String getTargetArch() {
        String result = this.targetArch;
        if (AbstractGolangMojo.isSafeEmpty(result) && this.isUseEnvVars()) {
            result = System.getenv("GOARCH");
        }
        return result;
    }

    public boolean isUseMavenProxy() {
        return this.useMavenProxy;
    }

    public boolean getSupposeSdkArchiveFileName() {
        return this.supposeSdkArchiveFileName;
    }

    @Nullable
    public ProxySettings getProxy() {
        return this.proxy;
    }

    @Nullable
    public String getOSXVersion() {
        return this.osxVersion;
    }

    @Nonnull
    public String getGoVersion() {
        return this.goVersion;
    }

    @Nullable
    public String getGoRoot() {
        String result = this.goRoot;
        if (AbstractGolangMojo.isSafeEmpty(result) && this.isUseEnvVars()) {
            result = System.getenv("GOROOT");
        }
        return result;
    }

    @Nullable
    public String getGoRootBootstrap() {
        String result = this.goRootBootstrap;
        if (AbstractGolangMojo.isSafeEmpty(result) && this.isUseEnvVars()) {
            result = System.getenv("GOROOT_BOOTSTRAP");
        }
        return result;
    }

    @Nonnull
    public File getSources(boolean ensureExist) throws IOException {
        File result = new File(this.sources);
        if (ensureExist && !result.isDirectory()) {
            throw new IOException("Can't find GoLang project sources : " + result);
        }
        return result;
    }

    protected void addTmpBuildFlagIfNotPresented(String ... flags) {
        for (String s : flags) {
            if (this.tempBuildFlags.contains(s)) continue;
            boolean found = false;
            if (this.buildFlags != null) {
                for (String b : this.buildFlags) {
                    if (!s.equals(b)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.tempBuildFlags.add(s);
        }
    }

    @Nonnull
    private synchronized HttpClient getHttpClient(@Nullable ProxySettings proxy) {
        if (this.httpClient == null) {
            HttpClientBuilder builder = HttpClients.custom();
            if (proxy != null) {
                String[] ignoreForAddresses;
                if (proxy.hasCredentials()) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(new AuthScope(proxy.host, proxy.port), (Credentials)new UsernamePasswordCredentials(proxy.username, proxy.password));
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    this.getLog().debug((CharSequence)String.format("Credentials provider has been created for proxy (username : %s): %s", proxy.username, proxy.toString()));
                }
                String[] stringArray = ignoreForAddresses = proxy.nonProxyHosts == null ? new String[]{} : proxy.nonProxyHosts.split("\\|");
                if (ignoreForAddresses.length > 0) {
                    Object[] matchers = new WildCardMatcher[ignoreForAddresses.length];
                    for (int i = 0; i < ignoreForAddresses.length; ++i) {
                        matchers[i] = new WildCardMatcher(ignoreForAddresses[i]);
                    }
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxy.host, proxy.port, proxy.protocol), (WildCardMatcher[])matchers){
                        final /* synthetic */ WildCardMatcher[] val$matchers;
                        {
                            this.val$matchers = wildCardMatcherArray;
                            super(x0);
                        }

                        @Nonnull
                        public HttpRoute determineRoute(@Nonnull HttpHost host, @Nonnull HttpRequest request, @Nonnull HttpContext context) throws HttpException {
                            String hostName = host.getHostName();
                            for (WildCardMatcher m : this.val$matchers) {
                                if (!m.match(hostName)) continue;
                                AbstractGolangMojo.this.getLog().debug((CharSequence)("Ignoring proxy for host : " + hostName));
                                return new HttpRoute(host);
                            }
                            return super.determineRoute(host, request, context);
                        }
                    };
                    builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                    this.getLog().debug((CharSequence)("Route planner tuned to ignore proxy for addresses : " + Arrays.toString(matchers)));
                }
            }
            builder.setUserAgent("mvn-golang-wrapper-agent/1.0");
            this.httpClient = builder.build();
        }
        return this.httpClient;
    }

    @Nullable
    private ProxySettings extractProxySettings() {
        ProxySettings result;
        if (this.isUseMavenProxy()) {
            Proxy activeMavenProxy = this.settings == null ? null : this.settings.getActiveProxy();
            result = activeMavenProxy == null ? null : new ProxySettings(activeMavenProxy);
            this.getLog().debug((CharSequence)("Detected maven proxy : " + result));
        } else {
            result = this.proxy;
            if (result != null) {
                this.getLog().debug((CharSequence)("Defined proxy : " + result));
            }
        }
        return result;
    }

    @Nonnull
    @ReturnsOriginal
    private RequestConfig.Builder processRequestConfig(@Nullable ProxySettings proxySettings, @Nonnull RequestConfig.Builder config) {
        if (proxySettings != null) {
            HttpHost proxyHost = new HttpHost(proxySettings.host, proxySettings.port, proxySettings.protocol);
            config.setProxy(proxyHost);
        }
        return config;
    }

    @Nonnull
    private String loadGoLangSdkList(@Nullable ProxySettings proxySettings) throws IOException {
        String sdksite = this.getSdkSite();
        this.getLog().warn((CharSequence)("Loading list of available GoLang SDKs from " + sdksite));
        HttpGet get = new HttpGet(sdksite);
        RequestConfig config = this.processRequestConfig(proxySettings, RequestConfig.custom()).build();
        get.setConfig(config);
        get.addHeader("Accept", "application/xml");
        try {
            HttpResponse response = this.getHttpClient(proxySettings).execute((HttpUriRequest)get);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                this.getLog().info((CharSequence)"GoLang SDK list has been loaded successfuly");
                this.getLog().debug((CharSequence)content);
                String string = content;
                return string;
            }
            throw new IOException(String.format("Can't load list of SDKs from %s : %d %s", sdksite, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        finally {
            get.releaseConnection();
        }
    }

    @Nonnull
    private Document convertSdkListToDocument(@Nonnull String sdkListAsString) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(sdkListAsString)));
        }
        catch (ParserConfigurationException ex) {
            this.getLog().error((CharSequence)"Can't configure XML parser", (Throwable)ex);
            throw new IOException("Can't configure XML parser", ex);
        }
        catch (SAXException ex) {
            this.getLog().error((CharSequence)"Can't parse document", (Throwable)ex);
            throw new IOException("Can't parse document", ex);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Unexpected IOException", (Throwable)ex);
            throw new IOException("Unexpected IOException", ex);
        }
    }

    private void printEcho() {
        if (this.echoWarn != null) {
            for (String s : this.echoWarn) {
                this.getLog().warn((CharSequence)s);
            }
        }
        if (this.echo != null) {
            for (String s : this.echo) {
                this.getLog().info((CharSequence)s);
            }
        }
    }

    protected void logOptionally(@Nonnull String message) {
        if (this.getLog().isDebugEnabled() || this.verbose) {
            this.getLog().info((CharSequence)message);
        }
    }

    private void initConsoleBuffers() {
        this.getLog().debug((CharSequence)"Initing console out and console err buffers");
        this.consoleErrBuffer = new ByteArrayOutputStream();
        this.consoleOutBuffer = new ByteArrayOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File unpackArchToFolder(@Nonnull File archiveFile, @Nonnull String folderInArchive, @Nonnull File destinationFolder) throws IOException {
        this.getLog().info((CharSequence)String.format("Unpacking archive %s to folder %s", archiveFile.getName(), destinationFolder.getName()));
        boolean detectedError = true;
        try {
            int unpackedFileCounter = UnpackUtils.unpackFileToFolder(this.getLog(), folderInArchive, archiveFile, destinationFolder, true);
            if (unpackedFileCounter == 0) {
                throw new IOException("Couldn't find folder '" + folderInArchive + "' in archive or the archive is empty");
            }
            this.getLog().info((CharSequence)("Unpacked " + unpackedFileCounter + " file(s)"));
            detectedError = false;
        }
        finally {
            if (detectedError && !this.isKeepUnarchFolderIfError()) {
                this.logOptionally("Deleting folder because error during unpack : " + destinationFolder);
                FileUtils.deleteQuietly((File)destinationFolder);
            }
        }
        return destinationFolder;
    }

    @Nonnull
    private String extractSDKFileName(@Nonnull String listUrl, @Nonnull Document doc, @Nonnull String sdkBaseName, @Nonnull @MustNotContainNull String[] allowedExtensions) throws IOException {
        this.getLog().debug((CharSequence)("Looking for SDK started with base name : " + sdkBaseName));
        HashSet<String> variants = new HashSet<String>();
        for (String ext : allowedExtensions) {
            variants.add(sdkBaseName + '.' + ext);
        }
        ArrayList<String> listedSdk = new ArrayList<String>();
        Element root = doc.getDocumentElement();
        if ("ListBucketResult".equals(root.getTagName())) {
            NodeList list = root.getElementsByTagName("Contents");
            for (int i = 0; i < list.getLength(); ++i) {
                Element element = (Element)list.item(i);
                NodeList keys = element.getElementsByTagName("Key");
                if (keys.getLength() <= 0) continue;
                String text = keys.item(0).getTextContent();
                if (variants.contains(text)) {
                    this.logOptionally("Detected compatible SDK in the SDK list : " + text);
                    return text;
                }
                listedSdk.add(text);
            }
            if (this.supposeSdkArchiveFileName) {
                String supposedSdkName = sdkBaseName + '.' + (SystemUtils.IS_OS_WINDOWS ? "zip" : "tar.gz");
                this.getLog().warn((CharSequence)"Can't find SDK file in the loaded list");
                this.getLog().debug((CharSequence)"..................................................");
                for (String s : listedSdk) {
                    this.getLog().debug((CharSequence)s);
                }
                this.getLog().debug((CharSequence)"..................................................");
                this.getLog().warn((CharSequence)("Supposed name of SDK archive is " + supposedSdkName + ", trying to load it directly! It can be disabled with <supposeSdkArchiveFileName>false</supposeSdkArchiveFileName>)"));
                return supposedSdkName;
            }
            this.getLog().error((CharSequence)("Can't find any SDK to be used as " + sdkBaseName));
            this.getLog().error((CharSequence)("GoLang list contains listed SDKs (" + listUrl + ")"));
            this.getLog().error((CharSequence)"It is possible directly define link to SDK through configuration parameter <sdkDownloadUrl>..</sdkDownloadUrl>");
            this.getLog().error((CharSequence)"..................................................");
            for (String s : listedSdk) {
                this.getLog().error((CharSequence)s);
            }
            throw new IOException("Can't find SDK : " + sdkBaseName);
        }
        throw new IOException("It is not a ListBucket file [" + root.getTagName() + ']');
    }

    @Nonnull
    private String findSdkArchiveFileName(@Nullable ProxySettings proxySettings, @Nonnull String sdkBaseName) throws IOException {
        String result = this.getSdkArchiveName();
        if (AbstractGolangMojo.isSafeEmpty(result)) {
            Document parsed = this.convertSdkListToDocument(this.loadGoLangSdkList(proxySettings));
            result = this.extractSDKFileName(this.getSdkSite(), parsed, sdkBaseName, new String[]{"tar.gz", "zip"});
        } else {
            this.getLog().info((CharSequence)("SDK archive name is predefined : " + result));
        }
        return GetUtils.ensureNonNullStr((String)result);
    }

    private void warnIfContainsUC(@Nonnull String message, @Nonnull String str) {
        boolean detected = false;
        for (char c : str.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            detected = true;
            break;
        }
        if (detected) {
            this.getLog().warn((CharSequence)(message + " : " + str));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File findGoRoot(@Nullable ProxySettings proxySettings) throws IOException, MojoFailureException {
        File result;
        LOCKER.lock();
        try {
            String predefinedGoRoot = this.getGoRoot();
            if (AbstractGolangMojo.isSafeEmpty(predefinedGoRoot)) {
                File cacheFolder = new File(this.storeFolder);
                if (!cacheFolder.isDirectory()) {
                    this.logOptionally("Making SDK cache folder : " + cacheFolder);
                    if (!cacheFolder.mkdirs()) {
                        throw new IOException("Can't create folder " + cacheFolder);
                    }
                }
                String definedOsxVersion = this.getOSXVersion();
                String sdkVersion = this.getGoVersion();
                if (AbstractGolangMojo.isSafeEmpty(sdkVersion)) {
                    throw new MojoFailureException("GoLang SDK version is not defined!");
                }
                String sdkBaseName = String.format(NAME_PATTERN, sdkVersion, this.getOs(), this.getArch(), AbstractGolangMojo.isSafeEmpty(definedOsxVersion) ? "" : "-" + definedOsxVersion);
                this.warnIfContainsUC("Prefer usage of lower case chars only for SDK base name", sdkBaseName);
                result = AbstractGolangMojo.loadSDKAndUnpackIntoCache(this, proxySettings, cacheFolder, sdkBaseName, this.disableSdkLoad);
            } else {
                this.logOptionally("Detected predefined SDK root folder : " + predefinedGoRoot);
                result = new File(predefinedGoRoot);
                if (!result.isDirectory()) {
                    throw new MojoFailureException("Predefined SDK root is not a directory : " + result);
                }
            }
        }
        finally {
            LOCKER.unlock();
        }
        return result;
    }

    private void printBanner() {
        for (String s : BANNER) {
            this.getLog().info((CharSequence)s);
        }
    }

    public boolean isHideBanner() {
        return this.hideBanner;
    }

    protected boolean doesNeedOneMoreAttempt(@Nonnull ProcessResult result, @Nonnull String consoleOut, @Nonnull String consoleErr) throws IOException, MojoExecutionException {
        return false;
    }

    protected boolean doMainBusiness(@Nullable ProxySettings proxySettings, int maxAttempts) throws InterruptedException, MojoFailureException, MojoExecutionException, IOException {
        boolean error;
        block4: {
            ProcessResult result;
            int iterations = 0;
            error = false;
            while (true) {
                ProcessExecutor executor;
                if ((executor = this.prepareExecutor(proxySettings)) == null) {
                    this.logOptionally("The Mojo should not be executed");
                    break block4;
                }
                result = executor.executeNoTimeout();
                int resultCode = result.getExitValue();
                error = resultCode != 0 && !this.isIgnoreErrorExitCode();
                ++iterations;
                String outLog = this.extractOutAsString();
                String errLog = this.extractErrorOutAsString();
                if (error || this.processConsoleOut(resultCode, outLog, errLog)) {
                    this.printLogs(error || this.enforcePrintOutput(), outLog, errLog);
                }
                if (!this.doesNeedOneMoreAttempt(result, outLog, errLog)) break;
                if (iterations > maxAttempts) {
                    throw new MojoExecutionException("Too many iterations detected, may be some loop and bug at mojo " + ((Object)((Object)this)).getClass().getName());
                }
                this.getLog().warn((CharSequence)"Make one more attempt...");
            }
            if (this.isIgnoreErrorExitCode()) break block4;
            this.assertProcessResult(result);
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Execution is skipped by flag");
        } else {
            if (!this.isHideBanner()) {
                this.printBanner();
            }
            this.printEcho();
            ProxySettings proxySettings = this.extractProxySettings();
            this.beforeExecution(proxySettings);
            boolean error = false;
            try {
                error = this.doMainBusiness(proxySettings, 10);
            }
            catch (IOException ex) {
                error = true;
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (InterruptedException ex) {
                error = true;
            }
            finally {
                this.afterExecution(null, error);
            }
        }
    }

    public void beforeExecution(@Nullable ProxySettings proxySettings) throws MojoFailureException, MojoExecutionException {
    }

    public void afterExecution(@Nullable ProxySettings proxySettings, boolean error) throws MojoFailureException, MojoExecutionException {
    }

    public boolean enforcePrintOutput() {
        return false;
    }

    @Nonnull
    private String extractOutAsString() {
        return new String(this.consoleOutBuffer.toByteArray(), Charset.defaultCharset());
    }

    @Nonnull
    private String extractErrorOutAsString() {
        return new String(this.consoleErrBuffer.toByteArray(), Charset.defaultCharset());
    }

    protected void printLogs(boolean forcePrint, @Nonnull String outLog, @Nonnull String errLog) {
        boolean errLogNotEmpty;
        boolean outLogNotEmpty = !outLog.isEmpty();
        boolean bl = errLogNotEmpty = !errLog.isEmpty();
        if (outLogNotEmpty) {
            if (forcePrint || this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"---------Exec.Out---------");
                for (String str : outLog.split("\n")) {
                    this.getLog().info((CharSequence)StrUtils.trimRight((String)str));
                }
                this.getLog().info((CharSequence)"");
            } else {
                this.getLog().debug((CharSequence)"There is not any log out from the process");
            }
        }
        if (errLogNotEmpty) {
            this.getLog().error((CharSequence)"");
            this.getLog().error((CharSequence)"---------Exec.Err---------");
            for (String str : errLog.split("\n")) {
                this.getLog().error((CharSequence)StrUtils.trimRight((String)str));
            }
            this.getLog().error((CharSequence)"");
        } else {
            this.getLog().debug((CharSequence)"There is not any log error from the process");
        }
    }

    private void assertProcessResult(@Nonnull ProcessResult result) throws MojoFailureException {
        int code = result.getExitValue();
        if (code != 0) {
            throw new MojoFailureException("Process exit code : " + code);
        }
    }

    public boolean isSourceFolderRequired() {
        return false;
    }

    public boolean isMojoMustNotBeExecuted() throws MojoFailureException {
        try {
            return this.isSourceFolderRequired() && !this.getSources(false).isDirectory();
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't check source folder", (Throwable)ex);
        }
    }

    @Nonnull
    @MustNotContainNull
    public abstract String[] getTailArguments();

    @Nonnull
    @MustNotContainNull
    public String[] getOptionalExtraTailArguments() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Nonnull
    public String makeExecutableFileSubpath() {
        return this.getExecSubpath() + File.separatorChar + this.getExec();
    }

    @Nonnull
    public abstract String getGoCommand();

    @Nonnull
    @MustNotContainNull
    public abstract String[] getCommandFlags();

    private void addEnvVar(@Nonnull ProcessExecutor executor, @Nonnull String name, @Nonnull String value) {
        this.logOptionally(" $" + name + " = " + value);
        executor.environment(name, value);
    }

    @Nullable
    private ProcessExecutor prepareExecutor(@Nullable ProxySettings proxySettings) throws IOException, MojoFailureException {
        File gorootbootstrap;
        File executableFileInPathOrRoot;
        this.initConsoleBuffers();
        String execNameAdaptedForOs = AbstractGolangMojo.adaptExecNameForOS(this.makeExecutableFileSubpath());
        File detectedRoot = this.findGoRoot(proxySettings);
        String gobin = this.getGoBin();
        File gopath = this.findGoPath(true);
        if (this.isMojoMustNotBeExecuted()) {
            return null;
        }
        String toolName = FilenameUtils.normalize((String)((String)GetUtils.ensureNonNull((Object)this.getUseGoTool(), (Object)execNameAdaptedForOs)));
        File executableFileInBin = gobin == null ? null : new File(AbstractGolangMojo.getPathToFolder(gobin) + AbstractGolangMojo.adaptExecNameForOS(this.getExec()));
        Object[] exeVariants = new File[]{executableFileInBin, executableFileInPathOrRoot = new File(AbstractGolangMojo.getPathToFolder(detectedRoot) + toolName)};
        File foundExecutableTool = AbstractGolangMojo.findExisting((File[])exeVariants);
        if (foundExecutableTool == null) {
            throw new MojoFailureException("Can't find executable file : " + Arrays.toString(exeVariants));
        }
        this.logOptionally("Executable file detected : " + foundExecutableTool);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(foundExecutableTool.getAbsolutePath());
        String gocommand = this.getGoCommand();
        if (!gocommand.isEmpty()) {
            commandLine.add(this.getGoCommand());
        }
        for (String s : this.getCommandFlags()) {
            commandLine.add(s);
        }
        for (String s : this.getBuildFlags()) {
            commandLine.add(s);
        }
        for (String s : this.getTailArguments()) {
            commandLine.add(s);
        }
        for (String s : this.getOptionalExtraTailArguments()) {
            commandLine.add(s);
        }
        StringBuilder cli = new StringBuilder();
        int index = 0;
        for (String s : commandLine) {
            if (cli.length() > 0) {
                cli.append(' ');
            }
            if (index == 0) {
                cli.append(execNameAdaptedForOs);
            } else {
                cli.append(s);
            }
            ++index;
        }
        this.getLog().info((CharSequence)String.format("Prepared command line : %s", cli.toString()));
        ProcessExecutor result = new ProcessExecutor(commandLine);
        File sourcesFile = this.getSources(this.isSourceFolderRequired());
        this.logOptionally("GoLang project sources folder : " + sourcesFile);
        if (sourcesFile.isDirectory()) {
            result.directory(sourcesFile);
        }
        this.logOptionally("");
        this.logOptionally("....Environment vars....");
        this.addEnvVar(result, "GOROOT", detectedRoot.getAbsolutePath());
        if (this.isEnforceGoPathToEnd()) {
            this.addEnvVar(result, "GOPATH", AbstractGolangMojo.preparePath(this.getExtraPathToAddToGoPathBeforeSources(), AbstractGolangMojo.removeSrcFolderAtEndIfPresented(sourcesFile.getAbsolutePath()), this.getExtraPathToAddToGoPathToEnd(), gopath.getAbsolutePath()));
        } else {
            this.addEnvVar(result, "GOPATH", AbstractGolangMojo.preparePath(gopath.getAbsolutePath(), this.getExtraPathToAddToGoPathBeforeSources(), AbstractGolangMojo.removeSrcFolderAtEndIfPresented(sourcesFile.getAbsolutePath()), this.getExtraPathToAddToGoPathToEnd()));
        }
        if (gobin == null) {
            this.getLog().warn((CharSequence)"GOBIN is disabled by direct order");
        } else {
            this.addEnvVar(result, "GOBIN", gobin);
        }
        String trgtOs = this.getTargetOS();
        String trgtArch = this.getTargetArch();
        String trgtArm = this.getTargetArm();
        if (trgtOs != null) {
            this.addEnvVar(result, "GOOS", trgtOs);
        }
        if (trgtArm != null) {
            this.addEnvVar(result, "GOARM", trgtArm);
        }
        if (trgtArch != null) {
            this.addEnvVar(result, "GOARCH", trgtArch);
        }
        if ((gorootbootstrap = this.findGoRootBootstrap(true)) != null) {
            this.addEnvVar(result, "GOROOT_BOOTSTRAP", gorootbootstrap.getAbsolutePath());
        }
        String thePath = GetUtils.ensureNonNullStr((String)System.getenv("PATH"));
        thePath = AbstractGolangMojo.preparePath(thePath, detectedRoot + File.separator + this.getExecSubpath(), gobin);
        this.addEnvVar(result, "PATH", thePath);
        for (Map.Entry<?, ?> record : this.getEnv().entrySet()) {
            this.addEnvVar(result, record.getKey().toString(), record.getValue().toString());
        }
        this.logOptionally("........................");
        result.redirectOutput((OutputStream)this.consoleOutBuffer);
        result.redirectError((OutputStream)this.consoleErrBuffer);
        return result;
    }

    @Nonnull
    protected String getExtraPathToAddToGoPathToEnd() {
        return "";
    }

    @Nonnull
    protected String getExtraPathToAddToGoPathBeforeSources() {
        String result = "";
        if (this.addToGoPath != null) {
            result = AbstractGolangMojo.preparePath(this.addToGoPath);
        }
        return result;
    }

    protected boolean processConsoleOut(int exitCode, @Nonnull String out, @Nonnull String err) throws MojoFailureException, MojoExecutionException {
        File fileToWriteErr;
        File reportsFolderFile = new File(this.getReportsFolder());
        String fileOut = this.getOutLogFile();
        String fileErr = this.getErrLogFile();
        File fileToWriteOut = fileOut == null || fileOut.trim().isEmpty() ? null : new File(reportsFolderFile, fileOut);
        File file = fileToWriteErr = fileErr == null || fileErr.trim().isEmpty() ? null : new File(reportsFolderFile, fileErr);
        if (fileToWriteOut != null) {
            this.getLog().debug((CharSequence)("Reports folder : " + reportsFolderFile));
            if (!reportsFolderFile.isDirectory() && !reportsFolderFile.mkdirs()) {
                throw new MojoExecutionException("Can't create folder for console logs : " + reportsFolderFile);
            }
            try {
                this.getLog().debug((CharSequence)("Writing out console log : " + fileToWriteErr));
                FileUtils.write((File)fileToWriteOut, (CharSequence)out, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't save console output log into file : " + fileToWriteOut, (Exception)ex);
            }
        }
        if (fileToWriteErr != null) {
            this.getLog().debug((CharSequence)("Reports folder : " + reportsFolderFile));
            if (!reportsFolderFile.isDirectory() && !reportsFolderFile.mkdirs()) {
                throw new MojoExecutionException("Can't create folder for console logs : " + reportsFolderFile);
            }
            try {
                this.getLog().debug((CharSequence)("Writing error console log : " + fileToWriteErr));
                FileUtils.write((File)fileToWriteErr, (CharSequence)err, (String)"UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can't save console error log into file : " + fileToWriteErr, (Exception)ex);
            }
        }
        return true;
    }
}

