/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="mvninstall", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GolangMvnInstallMojo
extends AbstractMojo {
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactInstaller installer;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(name="compression", defaultValue="9")
    private int compression;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File archive = this.compressProjectFiles();
            try {
                this.installer.install(archive, this.project.getArtifact(), this.localRepository);
            }
            finally {
                FileUtils.deleteQuietly((File)archive);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Detected unexpected IOException, check the log!", (Exception)ex);
        }
        catch (ArtifactInstallationException ex) {
            throw new MojoFailureException("Can't install the artifact!");
        }
    }

    private void safeCopyDirectory(@Nullable String src, @Nonnull File dst) throws IOException {
        if (src == null || src.isEmpty()) {
            return;
        }
        File srcFile = new File(src);
        if (srcFile.isDirectory()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Copying %s => %s", srcFile.getAbsolutePath(), dst.getAbsolutePath()));
            }
            FileUtils.copyDirectoryToDirectory((File)srcFile, (File)dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEffectivePom(@Nonnull File folder) throws IOException {
        Model model = this.project.getModel();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(folder, "pom.xml"), false), "UTF-8");
            new MavenXpp3Writer().write((Writer)writer, model);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Effective pom has been written");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File compressProjectFiles() throws IOException {
        Artifact artifact = this.project.getArtifact();
        File resultZip = new File(this.project.getBuild().getDirectory(), artifact.getArtifactId() + '-' + artifact.getVersion() + '.' + artifact.getType());
        if (resultZip.isFile() && !resultZip.delete()) {
            throw new IOException("Can't delete file : " + resultZip);
        }
        File folderToPack = new File(".tmp_pack_folder_" + Long.toHexString(System.currentTimeMillis()).toUpperCase(Locale.ENGLISH));
        if (folderToPack.isDirectory()) {
            FileUtils.deleteDirectory((File)folderToPack);
        }
        if (!folderToPack.mkdirs()) {
            throw new IOException("Can't create temp folder : " + folderToPack);
        }
        try {
            this.saveEffectivePom(folderToPack);
            FileUtils.copyFileToDirectory((File)this.project.getFile(), (File)folderToPack);
            this.safeCopyDirectory(this.project.getBuild().getSourceDirectory(), folderToPack);
            this.safeCopyDirectory(this.project.getBuild().getTestSourceDirectory(), folderToPack);
            for (Resource res : this.project.getBuild().getResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack);
            }
            for (Resource res : this.project.getBuild().getTestResources()) {
                this.safeCopyDirectory(res.getDirectory(), folderToPack);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Packing folder %s to %s", folderToPack.getAbsolutePath(), resultZip.getAbsolutePath()));
            }
            ZipUtil.pack((File)folderToPack, (File)resultZip, (int)Math.min(9, Math.max(1, this.compression)));
        }
        finally {
            FileUtils.deleteQuietly((File)folderToPack);
        }
        return resultZip;
    }
}

