/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.matchers;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.matchers.IsJson;
import com.jayway.jsonpath.matchers.WithJsonPath;
import com.jayway.jsonpath.matchers.WithoutJsonPath;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class JsonPathMatchers {
    private JsonPathMatchers() {
        throw new AssertionError((Object)"prevent instantiation");
    }

    public static Matcher<? super Object> hasJsonPath(String jsonPath) {
        return Matchers.describedAs((String)"has json path %0", JsonPathMatchers.hasJsonPath(jsonPath, Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), Matchers.empty()}))), (Object[])new Object[]{jsonPath});
    }

    public static <T> Matcher<? super Object> hasJsonPath(String jsonPath, Matcher<T> resultMatcher) {
        return JsonPathMatchers.isJson(JsonPathMatchers.withJsonPath(jsonPath, resultMatcher));
    }

    public static Matcher<? super Object> hasNoJsonPath(String jsonPath) {
        return JsonPathMatchers.isJson(JsonPathMatchers.withoutJsonPath(jsonPath, new Predicate[0]));
    }

    public static Matcher<Object> isJson() {
        return JsonPathMatchers.isJson(JsonPathMatchers.withJsonPath("$..*", new Predicate[0]));
    }

    public static Matcher<Object> isJson(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<String> isJsonString(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<File> isJsonFile(Matcher<? super ReadContext> matcher) {
        return new IsJson(matcher);
    }

    public static Matcher<? super ReadContext> withJsonPath(String jsonPath, Predicate ... filters) {
        return JsonPathMatchers.withJsonPath(JsonPath.compile((String)jsonPath, (Predicate[])filters));
    }

    public static Matcher<? super ReadContext> withJsonPath(JsonPath jsonPath) {
        return Matchers.describedAs((String)"with json path %0", JsonPathMatchers.withJsonPath(jsonPath, Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), Matchers.empty()}))), (Object[])new Object[]{jsonPath.getPath()});
    }

    public static Matcher<? super ReadContext> withoutJsonPath(String jsonPath, Predicate ... filters) {
        return JsonPathMatchers.withoutJsonPath(JsonPath.compile((String)jsonPath, (Predicate[])filters));
    }

    public static Matcher<? super ReadContext> withoutJsonPath(JsonPath jsonPath) {
        return new WithoutJsonPath(jsonPath);
    }

    public static <T> Matcher<? super ReadContext> withJsonPath(String jsonPath, Matcher<T> resultMatcher) {
        return JsonPathMatchers.withJsonPath(JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]), resultMatcher);
    }

    public static <T> Matcher<? super ReadContext> withJsonPath(JsonPath jsonPath, Matcher<T> resultMatcher) {
        return new WithJsonPath<T>(jsonPath, resultMatcher);
    }
}

