/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.filter.log.LogDetail;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;

public class LogConfig
implements Config {
    private final PrintStream defaultPrintStream;
    private final boolean prettyPrintingEnabled;
    private final LogDetail logDetailIfValidationFails;
    private final boolean isUserDefined;

    public LogConfig() {
        this(System.out, true, null, false);
    }

    public LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled) {
        this(defaultPrintStream, prettyPrintingEnabled, null, true);
    }

    private LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled, LogDetail logDetailIfValidationFails, boolean isUserDefined) {
        Validate.notNull((Object)defaultPrintStream, (String)"Stream to write logs to cannot be null", (Object[])new Object[0]);
        this.defaultPrintStream = defaultPrintStream;
        this.prettyPrintingEnabled = prettyPrintingEnabled;
        this.logDetailIfValidationFails = logDetailIfValidationFails;
        this.isUserDefined = isUserDefined;
    }

    public PrintStream defaultStream() {
        return this.defaultPrintStream;
    }

    public LogConfig defaultStream(PrintStream printStream) {
        return new LogConfig(printStream, true, this.logDetailIfValidationFails, true);
    }

    public boolean isPrettyPrintingEnabled() {
        return this.prettyPrintingEnabled;
    }

    public boolean isLoggingOfRequestAndResponseIfValidationFailsEnabled() {
        return this.logDetailIfValidationFails != null;
    }

    public LogDetail logDetailOfRequestAndResponseIfValidationFails() {
        return this.logDetailIfValidationFails;
    }

    public LogConfig enablePrettyPrinting(boolean shouldEnable) {
        return new LogConfig(this.defaultPrintStream, shouldEnable, this.logDetailIfValidationFails, true);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails() {
        return this.enableLoggingOfRequestAndResponseIfValidationFails(LogDetail.ALL);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails(LogDetail logDetail) {
        return new LogConfig(this.defaultPrintStream, this.prettyPrintingEnabled, logDetail, true);
    }

    public static LogConfig logConfig() {
        return new LogConfig();
    }

    public LogConfig and() {
        return this;
    }

    public boolean isUserConfigured() {
        return this.isUserDefined;
    }
}

