/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.ner.dl;

import com.johnsnowlabs.ml.tensorflow.DatasetEncoderParams;
import com.johnsnowlabs.ml.tensorflow.DatasetEncoderParams$;
import com.johnsnowlabs.ml.tensorflow.NerDatasetEncoder;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper$;
import com.johnsnowlabs.nlp.annotators.ner.dl.NerDLModel;
import com.johnsnowlabs.nlp.embeddings.SparkWordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.SparkWordEmbeddings$;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddingsFormat$;
import com.johnsnowlabs.util.FileHelper$;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;

public final class NerDLModelPythonReader$ {
    public static final NerDLModelPythonReader$ MODULE$;
    private final String embeddingsMetaFile;
    private final String embeddingsFile;
    private final String tagsFile;
    private final String charsFile;

    static {
        new NerDLModelPythonReader$();
    }

    public String embeddingsMetaFile() {
        return this.embeddingsMetaFile;
    }

    public String embeddingsFile() {
        return this.embeddingsFile;
    }

    public String tagsFile() {
        return this.tagsFile;
    }

    public String charsFile() {
        return this.charsFile;
    }

    private List<String> readTags(String folder) {
        return Source$.MODULE$.fromFile(((Object)Paths.get(folder, this.tagsFile())).toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toList();
    }

    private List<Object> readChars(String folder) {
        Iterator lines = Source$.MODULE$.fromFile(((Object)Paths.get(folder, this.charsFile())).toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines();
        return Predef$.MODULE$.charArrayOps(((String)lines.toList().head()).toCharArray()).toList();
    }

    private int readEmbeddingsHead(String folder, SparkSession spark) {
        String metaFile = ((Object)Paths.get(folder, this.embeddingsMetaFile())).toString();
        return new StringOps(Predef$.MODULE$.augmentString((String)Source$.MODULE$.fromFile(metaFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().head())).toInt();
    }

    private SparkWordEmbeddings readEmbeddings(String folder, SparkSession spark, int embeddingsDim) {
        return SparkWordEmbeddings$.MODULE$.apply(spark.sparkContext(), ((Object)Paths.get(folder, this.embeddingsFile())).toString(), embeddingsDim, WordEmbeddingsFormat$.MODULE$.BINARY());
    }

    public NerDLModel read(String folder, SparkSession spark) {
        FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12))).append((Object)"_bundle").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        fs.copyToLocalFile(new Path(folder), new Path(tmpFolder));
        int embeddingsDim = this.readEmbeddingsHead(folder, spark);
        SparkWordEmbeddings embeddings2 = this.readEmbeddings(folder, spark, embeddingsDim);
        List<String> labels = this.readTags(folder);
        List<Object> chars = this.readChars(folder);
        DatasetEncoderParams settings = new DatasetEncoderParams(labels, chars, DatasetEncoderParams$.MODULE$.apply$default$3());
        WordEmbeddings wordEmbeddings2 = embeddings2.wordEmbeddings();
        NerDatasetEncoder encoder = new NerDatasetEncoder((Function1<String, float[]>)new Serializable(wordEmbeddings2){
            public static final long serialVersionUID = 0L;
            private final WordEmbeddings eta$0$1$1;

            public final float[] apply(String word) {
                return this.eta$0$1$1.getEmbeddings(word);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, settings);
        TensorflowWrapper tf = TensorflowWrapper$.MODULE$.read(folder, false);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        return (NerDLModel)new NerDLModel().setTensorflow(tf).setDatasetParams(encoder.params()).setDims(embeddingsDim).setIndexPath(embeddings2.clusterFilePath().toString());
    }

    private NerDLModelPythonReader$() {
        MODULE$ = this;
        this.embeddingsMetaFile = "embeddings.meta";
        this.embeddingsFile = "embeddings";
        this.tagsFile = "tags.csv";
        this.charsFile = "chars.csv";
    }
}

