/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.embeddings;

import com.johnsnowlabs.nlp.AnnotatorApproach;
import com.johnsnowlabs.nlp.HasWordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.SparkWordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.SparkWordEmbeddings$;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddingsFormat$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.sql.SparkSession;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0003\u0003Y!AG!qaJ|\u0017m\u00195XSRDwk\u001c:e\u000b6\u0014W\r\u001a3j]\u001e\u001c(BA\u0002\u0005\u0003))WNY3eI&twm\u001d\u0006\u0003\u000b\u0019\t1A\u001c7q\u0015\t9\u0001\"\u0001\u0007k_\"t7O\\8xY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001+\raAhE\n\u0004\u00015q\u0003c\u0001\b\u0010#5\tA!\u0003\u0002\u0011\t\t\t\u0012I\u001c8pi\u0006$xN]!qaJ|\u0017m\u00195\u0011\u0005I\u0019B\u0002\u0001\u0003\u0006)\u0001\u0011\r!\u0006\u0002\u0002\u001bF\u0011a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\b\u001d>$\b.\u001b8h%\rird\u000b\u0004\u0005=\u0001\u0001AD\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002!SEi\u0011!\t\u0006\u0003E\r\n!!\u001c7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001eL!AK\u0011\u0003\u000b5{G-\u001a7\u0011\u00059a\u0013BA\u0017\u0005\u0005EA\u0015m],pe\u0012,UNY3eI&twm\u001d\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA\u0001\\1oO*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u00055\tU\u000f^8DY>\u001cX-\u00192mK\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"\u0012!\u000f\t\u0005u\u0001Y\u0014#D\u0001\u0003!\t\u0011B\bB\u0003>\u0001\t\u0007aHA\u0001B#\t1\u0012\bC\u0004A\u0001\t\u0007I\u0011A!\u0002)M|WO]2f\u000b6\u0014W\r\u001a3j]\u001e\u001c\b+\u0019;i+\u0005\u0011\u0005cA\"G\u00116\tAI\u0003\u0002FC\u0005)\u0001/\u0019:b[&\u0011q\t\u0012\u0002\u0006!\u0006\u0014\u0018-\u001c\t\u0003\u00132s!a\u0006&\n\u0005-C\u0012A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\r\t\rA\u0003\u0001\u0015!\u0003C\u0003U\u0019x.\u001e:dK\u0016k'-\u001a3eS:<7\u000fU1uQ\u0002BqA\u0015\u0001C\u0002\u0013\u00051+\u0001\tf[\n,G\rZ5oON4uN]7biV\tA\u000b\u0005\u0002D+&\u0011a\u000b\u0012\u0002\t\u0013:$\b+\u0019:b[\"1\u0001\f\u0001Q\u0001\nQ\u000b\u0011#Z7cK\u0012$\u0017N\\4t\r>\u0014X.\u0019;!\u0011\u001dQ\u0006A1A\u0005\u0002M\u000bq\"Z7cK\u0012$\u0017N\\4t\u001d\u0012KWn\u001d\u0005\u00079\u0002\u0001\u000b\u0011\u0002+\u0002!\u0015l'-\u001a3eS:<7O\u0014#j[N\u0004\u0003\"\u00020\u0001\t\u0003y\u0016aE:fi\u0016k'-\u001a3eS:<7oU8ve\u000e,G\u0003B\u001eaE\u001eDQ!Y/A\u0002!\u000bA\u0001]1uQ\")1-\u0018a\u0001I\u0006)a\u000eR5ngB\u0011q#Z\u0005\u0003Mb\u00111!\u00138u\u0011\u0015AW\f1\u0001j\u0003\u00191wN]7biB\u0011!.\u001c\b\u0003u-L!\u0001\u001c\u0002\u0002)]{'\u000fZ#nE\u0016$G-\u001b8hg\u001a{'/\\1u\u0013\tqwN\u0001\u0004G_Jl\u0017\r\u001e\u0006\u0003Y\nAQA\u0018\u0001\u0005\u0002E$Ba\u000f:ti\")\u0011\r\u001da\u0001\u0011\")1\r\u001da\u0001I\")\u0001\u000e\u001da\u0001\u0011\")a\u000f\u0001C!o\u0006q!-\u001a4pe\u0016$&/Y5oS:<GC\u0001=|!\t9\u00120\u0003\u0002{1\t!QK\\5u\u0011\u0015!S\u000f1\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011qpI\u0001\u0004gFd\u0017bAA\u0002}\na1\u000b]1sWN+7o]5p]\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011!C8o)J\f\u0017N\\3e)\u0015A\u00181BA\b\u0011\u001d\ti!!\u0002A\u0002E\tQ!\\8eK2Da\u0001JA\u0003\u0001\u0004a\b\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0003E\u0019G.^:uKJ,UNY3eI&twm]\u000b\u0003\u0003/\u0001RaFA\r\u0003;I1!a\u0007\u0019\u0005\u0019y\u0005\u000f^5p]B\u0019!(a\b\n\u0007\u0005\u0005\"AA\nTa\u0006\u00148nV8sI\u0016k'-\u001a3eS:<7\u000fC\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(\u0005)2\r\\;ti\u0016\u0014X)\u001c2fI\u0012LgnZ:`I\u0015\fHc\u0001=\u0002*!Q\u00111FA\u0012\u0003\u0003\u0005\r!a\u0006\u0002\u0007a$\u0013\u0007\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\f\u0003I\u0019G.^:uKJ,UNY3eI&twm\u001d\u0011\t\r\r\u0001A\u0011AA\u001a+\t\t)\u0004E\u0003\u0018\u00033\t9\u0004E\u0002;\u0003sI1!a\u000f\u0003\u000599vN\u001d3F[\n,G\rZ5oONDq!a\u0010\u0001\t\u0003\n\t%A\u0003dY>\u001cX\rF\u0001y\u0001")
public abstract class ApproachWithWordEmbeddings<A extends ApproachWithWordEmbeddings<A, M>, M extends Model<M>>
extends AnnotatorApproach<M>
implements AutoCloseable {
    private final Param<String> sourceEmbeddingsPath = new Param((Identifiable)this, "sourceEmbeddingsPath", "Word embeddings file");
    private final IntParam embeddingsFormat = new IntParam((Identifiable)this, "embeddingsFormat", "Word vectors file format");
    private final IntParam embeddingsNDims = new IntParam((Identifiable)this, "embeddingsNDims", "Number of dimensions for word vectors");
    private Option<SparkWordEmbeddings> clusterEmbeddings = None$.MODULE$;

    public Param<String> sourceEmbeddingsPath() {
        return this.sourceEmbeddingsPath;
    }

    public IntParam embeddingsFormat() {
        return this.embeddingsFormat;
    }

    public IntParam embeddingsNDims() {
        return this.embeddingsNDims;
    }

    public A setEmbeddingsSource(String path, int nDims, Enumeration.Value format) {
        this.set(this.sourceEmbeddingsPath(), path);
        this.set((Param)this.embeddingsFormat(), BoxesRunTime.boxToInteger((int)format.id()));
        return (A)((ApproachWithWordEmbeddings)this.set((Param)this.embeddingsNDims(), BoxesRunTime.boxToInteger((int)nDims)));
    }

    public A setEmbeddingsSource(String path, int nDims, String format) {
        this.set(this.sourceEmbeddingsPath(), path);
        this.set((Param)this.embeddingsFormat(), BoxesRunTime.boxToInteger((int)WordEmbeddingsFormat$.MODULE$.str2frm(format).id()));
        return (A)((ApproachWithWordEmbeddings)this.set((Param)this.embeddingsNDims(), BoxesRunTime.boxToInteger((int)nDims)));
    }

    @Override
    public void beforeTraining(SparkSession spark) {
        if (this.isDefined(this.sourceEmbeddingsPath())) {
            this.clusterEmbeddings_$eq((Option<SparkWordEmbeddings>)new Some((Object)SparkWordEmbeddings$.MODULE$.apply(spark.sparkContext(), (String)this.$(this.sourceEmbeddingsPath()), BoxesRunTime.unboxToInt((Object)this.$((Param)this.embeddingsNDims())), WordEmbeddingsFormat$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this.$((Param)this.embeddingsFormat()))))));
        }
    }

    @Override
    public void onTrained(M model2, SparkSession spark) {
        if (this.isDefined(this.sourceEmbeddingsPath())) {
            ((HasWordEmbeddings)model2).setDims(BoxesRunTime.unboxToInt((Object)this.$((Param)this.embeddingsNDims())));
            ((HasWordEmbeddings)model2).setIndexPath(((SparkWordEmbeddings)this.clusterEmbeddings().get()).clusterFilePath().toString());
        }
    }

    private Option<SparkWordEmbeddings> clusterEmbeddings() {
        return this.clusterEmbeddings;
    }

    private void clusterEmbeddings_$eq(Option<SparkWordEmbeddings> x$1) {
        this.clusterEmbeddings = x$1;
    }

    public Option<WordEmbeddings> embeddings() {
        return this.clusterEmbeddings().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WordEmbeddings apply(SparkWordEmbeddings c) {
                return c.wordEmbeddings();
            }
        });
    }

    @Override
    public void close() {
        if (this.embeddings().nonEmpty()) {
            ((WordEmbeddings)this.embeddings().get()).close();
        }
    }
}

