/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.embeddings;

import com.johnsnowlabs.nlp.embeddings.SparkWordEmbeddings;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddingsFormat$;
import com.johnsnowlabs.nlp.embeddings.WordEmbeddingsIndexer$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ivy.util.FileUtil;
import org.apache.spark.SparkContext;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class SparkWordEmbeddings$
implements Serializable {
    public static final SparkWordEmbeddings$ MODULE$;

    static {
        new SparkWordEmbeddings$();
    }

    private void indexEmbeddings(String sourceEmbeddingsPath, String localFile, Enumeration.Value format, SparkContext spark) {
        FileSystem fs = FileSystem.get((Configuration)spark.hadoopConfiguration());
        Enumeration.Value value = format;
        Enumeration.Value value2 = WordEmbeddingsFormat$.MODULE$.TEXT();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            String tmpFile = ((Object)Files.createTempFile("embeddings", ".txt", new FileAttribute[0]).toAbsolutePath()).toString();
            fs.copyToLocalFile(new Path(sourceEmbeddingsPath), new Path(tmpFile));
            WordEmbeddingsIndexer$.MODULE$.indexText(tmpFile, localFile);
            FileHelper$.MODULE$.delete(tmpFile, FileHelper$.MODULE$.delete$default$2());
        } else {
            Enumeration.Value value3 = format;
            Enumeration.Value value4 = WordEmbeddingsFormat$.MODULE$.BINARY();
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                String tmpFile = ((Object)Files.createTempFile("embeddings", ".bin", new FileAttribute[0]).toAbsolutePath()).toString();
                fs.copyToLocalFile(new Path(sourceEmbeddingsPath), new Path(tmpFile));
                WordEmbeddingsIndexer$.MODULE$.indexBinary(tmpFile, localFile);
                FileHelper$.MODULE$.delete(tmpFile, FileHelper$.MODULE$.delete$default$2());
            } else {
                Enumeration.Value value5 = format;
                Enumeration.Value value6 = WordEmbeddingsFormat$.MODULE$.SPARKNLP();
                if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                    FileSystem hdfs = FileSystem.get((Configuration)spark.hadoopConfiguration());
                    hdfs.copyToLocalFile(new Path(sourceEmbeddingsPath), new Path(localFile));
                    String fileName = new Path(sourceEmbeddingsPath).getName();
                    FileUtil.deepCopy((File)Paths.get(localFile, fileName).toFile(), (File)Paths.get(localFile, new String[0]).toFile(), null, (boolean)true);
                    FileHelper$.MODULE$.delete(((Object)Paths.get(localFile, fileName)).toString(), FileHelper$.MODULE$.delete$default$2());
                }
            }
        }
    }

    private String copyIndexToCluster(String localFile, String clusterFilePath, SparkContext spark) {
        FileSystem fs = FileSystem.get((Configuration)spark.hadoopConfiguration());
        Path src = new Path(localFile);
        Path dst = Path.mergePaths((Path)fs.getHomeDirectory(), (Path)new Path(clusterFilePath));
        fs.copyFromLocalFile(false, true, src, dst);
        fs.deleteOnExit(dst);
        spark.addFile(dst.toString(), true);
        return dst.toString();
    }

    public SparkWordEmbeddings apply(SparkContext spark, String sourceEmbeddingsPath, int dim, Enumeration.Value format) {
        java.nio.file.Path localFile = Files.createTempDirectory(new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12))).append((Object)"_idx").toString(), new FileAttribute[0]).toAbsolutePath();
        String name = localFile.toFile().getName();
        String clusterFilePath = Path.mergePaths((Path)new Path("/embeddings"), (Path)new Path(name)).toString();
        this.indexEmbeddings(sourceEmbeddingsPath, ((Object)localFile).toString(), format, spark);
        this.copyIndexToCluster(((Object)localFile).toString(), clusterFilePath, spark);
        FileHelper$.MODULE$.delete(((Object)localFile).toString(), FileHelper$.MODULE$.delete$default$2());
        return new SparkWordEmbeddings(clusterFilePath, dim);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkWordEmbeddings$() {
        MODULE$ = this;
    }
}

