/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.johnsnowlabs.nlp.pretrained.CloudResourceDownloader$;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.util.FileHelper$;
import com.johnsnowlabs.util.Version;
import com.johnsnowlabs.util.ZipArchiveUtil$;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001-\u0011qc\u00117pk\u0012\u0014Vm]8ve\u000e,Gi\\<oY>\fG-\u001a:\u000b\u0005\r!\u0011A\u00039sKR\u0014\u0018-\u001b8fI*\u0011QAB\u0001\u0004]2\u0004(BA\u0004\t\u00031Qw\u000e\u001b8t]><H.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\r%Y\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005I\u0011Vm]8ve\u000e,Gi\\<oY>\fG-\u001a:\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007EV\u001c7.\u001a;\u0011\u0005\u0005\"cBA\u0007#\u0013\t\u0019c\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012\u000f\u0011!A\u0003A!A!\u0002\u0013\u0001\u0013AB:4!\u0006$\b\u000e\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003!\u0003-\u0019\u0017m\u00195f\r>dG-\u001a:\t\u00111\u0002!\u0011!Q\u0001\n\u0001\naA]3hS>t\u0007\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\bF\u00031cI\u001aD\u0007\u0005\u0002\u0014\u0001!)q$\fa\u0001A!)\u0001&\fa\u0001A!)!&\fa\u0001A!9A&\fI\u0001\u0002\u0004\u0001\u0003b\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u0014Y\u0006\u001cH/T3uC\u0012\fG/\u0019,feNLwN\\\u000b\u0002qA\u0019Q\"\u000f\u0011\n\u0005ir!AB(qi&|g\u000eC\u0004=\u0001\u0001\u0007I\u0011A\u001f\u0002/1\f7\u000f^'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8`I\u0015\fHC\u0001 B!\tiq(\u0003\u0002A\u001d\t!QK\\5u\u0011\u001d\u00115(!AA\u0002a\n1\u0001\u001f\u00132\u0011\u0019!\u0005\u0001)Q\u0005q\u0005!B.Y:u\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0002BqA\u0012\u0001A\u0002\u0013\u0005q)\u0001\u0005nKR\fG-\u0019;b+\u0005A\u0005cA%O!6\t!J\u0003\u0002L\u0019\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u001b:\t!bY8mY\u0016\u001cG/[8o\u0013\ty%J\u0001\u0003MSN$\bCA\nR\u0013\t\u0011&A\u0001\tSKN|WO]2f\u001b\u0016$\u0018\rZ1uC\"9A\u000b\u0001a\u0001\n\u0003)\u0016\u0001D7fi\u0006$\u0017\r^1`I\u0015\fHC\u0001 W\u0011\u001d\u00115+!AA\u0002!Ca\u0001\u0017\u0001!B\u0013A\u0015!C7fi\u0006$\u0017\r^1!\u0011\u001dQ\u0006A1A\u0005\u0002m\u000bA\"\\3uC\u0012\fG/\u0019$jY\u0016,\u0012\u0001\t\u0005\u0007;\u0002\u0001\u000b\u0011\u0002\u0011\u0002\u001b5,G/\u00193bi\u00064\u0015\u000e\\3!\u0011!y\u0006\u0001#b\u0001\n\u0003\u0001\u0017AB2mS\u0016tG/F\u0001b!\t\u0011\u0017.D\u0001d\u0015\t!W-\u0001\u0002tg)\u0011amZ\u0001\tg\u0016\u0014h/[2fg*\u0011\u0001\u000eC\u0001\nC6\f'p\u001c8boNL!A[2\u0003\u0011\u0005k\u0017M_8o'NB\u0001\u0002\u001c\u0001\t\u0002\u0003\u0006K!Y\u0001\bG2LWM\u001c;!\u0011\u0015q\u0007\u0001\"\u0003p\u0003Y!wn\u001e8m_\u0006$W*\u001a;bI\u0006$\u0018-\u00134OK\u0016$G#\u0001 \t\u000bE\u0004A\u0011\u0001:\u0002\u0017I,7o\u001c7wK2Kgn\u001b\u000b\u0007gR4\b0!\u0001\u0011\u00075I\u0004\u000bC\u0003va\u0002\u0007\u0001%\u0001\u0003oC6,\u0007\"B<q\u0001\u0004A\u0014\u0001\u00037b]\u001e,\u0018mZ3\t\u000be\u0004\b\u0019\u0001>\u0002\u00151L'MV3sg&|g\u000e\u0005\u0002|}6\tAP\u0003\u0002~\r\u0005!Q\u000f^5m\u0013\tyHPA\u0004WKJ\u001c\u0018n\u001c8\t\r\u0005\r\u0001\u000f1\u0001{\u00031\u0019\b/\u0019:l-\u0016\u00148/[8o\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\nq\u0005-\u0011QBA\b\u0003#Aa!^A\u0003\u0001\u0004\u0001\u0003BB<\u0002\u0006\u0001\u0007\u0001\b\u0003\u0004z\u0003\u000b\u0001\rA\u001f\u0005\b\u0003\u0007\t)\u00011\u0001{\u0011\u0019\t)\u0002\u0001C!_\u0006)1\r\\8tK\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011AC2mK\u0006\u00148)Y2iKRIa(!\b\u0002 \u0005\u0005\u00121\u0005\u0005\u0007k\u0006]\u0001\u0019\u0001\u0011\t\r]\f9\u00021\u00019\u0011\u0019I\u0018q\u0003a\u0001u\"9\u00111AA\f\u0001\u0004Qx!CA\u0014\u0005\u0005\u0005\t\u0012AA\u0015\u0003]\u0019En\\;e%\u0016\u001cx.\u001e:dK\u0012{wO\u001c7pC\u0012,'\u000fE\u0002\u0014\u0003W1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QF\n\u0004\u0003Wa\u0001b\u0002\u0018\u0002,\u0011\u0005\u0011\u0011\u0007\u000b\u0003\u0003SA!\"!\u000e\u0002,E\u0005I\u0011AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\b\u0016\u0004A\u0005m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dc\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class CloudResourceDownloader
implements ResourceDownloader,
AutoCloseable {
    public final String com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$bucket;
    public final String com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$s3Path;
    public final String com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$cacheFolder;
    private final String region;
    private Option<String> lastMetadataVersion;
    private List<ResourceMetadata> metadata;
    private final String metadataFile;
    private AmazonS3 client;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return CloudResourceDownloader$.MODULE$.$lessinit$greater$default$4();
    }

    private AmazonS3 client$lzycompute() {
        CloudResourceDownloader cloudResourceDownloader = this;
        synchronized (cloudResourceDownloader) {
            if (!this.bitmap$0) {
                AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
                builder.setRegion(this.region);
                this.client = (AmazonS3)builder.build();
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
            this.region = null;
            return this.client;
        }
    }

    public Option<String> lastMetadataVersion() {
        return this.lastMetadataVersion;
    }

    public void lastMetadataVersion_$eq(Option<String> x$1) {
        this.lastMetadataVersion = x$1;
    }

    public List<ResourceMetadata> metadata() {
        return this.metadata;
    }

    public void metadata_$eq(List<ResourceMetadata> x$1) {
        this.metadata = x$1;
    }

    public String metadataFile() {
        return this.metadataFile;
    }

    public AmazonS3 client() {
        return this.bitmap$0 ? this.client : this.client$lzycompute();
    }

    private void downloadMetadataIfNeed() {
        block3: {
            S3Object obj;
            block2: {
                obj = this.client().getObject(this.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$bucket, this.metadataFile());
                if (this.lastMetadataVersion().isEmpty()) break block2;
                String string = obj.getObjectMetadata().getVersionId();
                Object object = this.lastMetadataVersion().get();
                if (!(string == null ? object != null : !string.equals(object))) break block3;
            }
            this.metadata_$eq(ResourceMetadata$.MODULE$.readResources((InputStream)obj.getObjectContent()));
            this.lastMetadataVersion_$eq((Option<String>)new Some((Object)obj.getObjectMetadata().getVersionId()));
        }
    }

    public Option<ResourceMetadata> resolveLink(String name, Option<String> language, Version libVersion, Version sparkVersion) {
        this.downloadMetadataIfNeed();
        return ResourceMetadata$.MODULE$.resolveResource(this.metadata(), name, language, libVersion, sparkVersion);
    }

    @Override
    public Option<String> download(String name, Option<String> language, Version libVersion, Version sparkVersion) {
        Option<ResourceMetadata> link = this.resolveLink(name, language, libVersion, sparkVersion);
        return link.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudResourceDownloader $outer;

            public final Option<String> apply(ResourceMetadata resource) {
                None$ none$;
                String s3FilePath = new StringOps(Predef$.MODULE$.augmentString(((Object)Paths.get(this.$outer.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$s3Path, resource.fileName())).toString())).replaceAllLiterally("\\", "/");
                File dstFile = new File(this.$outer.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$cacheFolder, resource.fileName());
                if (this.$outer.client().doesObjectExist(this.$outer.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$bucket, s3FilePath)) {
                    if (!dstFile.exists()) {
                        S3Object obj = this.$outer.client().getObject(this.$outer.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$bucket, s3FilePath);
                        String tmpFileName = ((Object)Files.createTempFile(resource.fileName(), "", new FileAttribute[0])).toString();
                        File tmpFile = new File(tmpFileName);
                        FileUtils.copyInputStreamToFile((InputStream)obj.getObjectContent(), (File)tmpFile);
                        FileUtils.moveFile((File)tmpFile, (File)dstFile);
                    }
                    String dstFileName = resource.isZipped() ? ZipArchiveUtil$.MODULE$.unzip(dstFile, ZipArchiveUtil$.MODULE$.unzip$default$2()) : dstFile.getPath();
                    none$ = new Some((Object)dstFileName);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void close() {
        this.client().shutdown();
    }

    @Override
    public void clearCache(String name, Option<String> language, Version libVersion, Version sparkVersion) {
        Option<ResourceMetadata> resources = ResourceMetadata$.MODULE$.resolveResource(this.metadata(), name, language, libVersion, sparkVersion);
        resources.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudResourceDownloader $outer;

            public final void apply(ResourceMetadata resource) {
                String fileName = ((Object)Paths.get(this.$outer.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$cacheFolder, resource.fileName())).toString();
                File file = new File(fileName);
                Object object = file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
                if (resource.isZipped()) {
                    String string = fileName.substring(fileName.length() - 4);
                    String string2 = ".zip";
                    Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
                    String unzipped = fileName.substring(0, fileName.length() - 4);
                    File unzippedFile = new File(unzipped);
                    if (unzippedFile.exists()) {
                        FileHelper$.MODULE$.delete(((Object)unzippedFile.toPath()).toString(), FileHelper$.MODULE$.delete$default$2());
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public CloudResourceDownloader(String bucket, String s3Path, String cacheFolder, String region) {
        this.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$bucket = bucket;
        this.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$s3Path = s3Path;
        this.com$johnsnowlabs$nlp$pretrained$CloudResourceDownloader$$cacheFolder = cacheFolder;
        this.region = region;
        this.lastMetadataVersion = None$.MODULE$;
        this.metadata = List$.MODULE$.empty();
        this.metadataFile = new StringOps(Predef$.MODULE$.augmentString(((Object)Paths.get(s3Path, "metadata.json")).toString())).replaceAllLiterally("\\", "/");
        if (!new File(cacheFolder).exists()) {
            FileUtils.forceMkdir((File)new File(cacheFolder));
        }
    }
}

