/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.nlp.pretrained.CloudResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.CloudResourceDownloader$;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.Build$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.Version;
import com.johnsnowlabs.util.Version$;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineModel$;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.util.DefaultParamsReadable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;

public final class ResourceDownloader$ {
    public static final ResourceDownloader$ MODULE$;
    private final String s3Bucket;
    private final String s3Path;
    private final String cacheFolder;
    private final Map<ResourceDownloader.ResourceRequest, PipelineStage> cache;
    private Version sparkVersion;
    private Version libVersion;
    private ResourceDownloader defaultDownloader;
    private volatile byte bitmap$0;

    static {
        new ResourceDownloader$();
    }

    private Version sparkVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sparkVersion = Version$.MODULE$.parse(ResourceHelper$.MODULE$.spark().version());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.sparkVersion;
        }
    }

    private Version libVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.libVersion = Version$.MODULE$.parse(Build$.MODULE$.version());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.libVersion;
        }
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Path() {
        return this.s3Path;
    }

    public String cacheFolder() {
        return this.cacheFolder;
    }

    private Map<ResourceDownloader.ResourceRequest, PipelineStage> cache() {
        return this.cache;
    }

    public Version sparkVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkVersion$lzycompute() : this.sparkVersion;
    }

    public Version libVersion() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.libVersion$lzycompute() : this.libVersion;
    }

    public ResourceDownloader defaultDownloader() {
        return this.defaultDownloader;
    }

    public void defaultDownloader_$eq(ResourceDownloader x$1) {
        this.defaultDownloader = x$1;
    }

    public String downloadResource(String name, Option<String> language) {
        Option<String> path = this.defaultDownloader().download(name, language, this.libVersion(), this.sparkVersion());
        Predef$.MODULE$.require(path.isDefined(), (Function0)new Serializable(name, language){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Option language$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Was not able to download: ", " for language: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", with libVersion: ", " and spark version: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.language$1, ResourceDownloader$.MODULE$.libVersion(), ResourceDownloader$.MODULE$.sparkVersion()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with downlader: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ResourceDownloader$.MODULE$.defaultDownloader()}))).toString();
            }
            {
                this.name$1 = name$1;
                this.language$1 = language$1;
            }
        });
        return (String)path.get();
    }

    public <TModel extends PipelineStage> TModel downloadModel(DefaultParamsReadable<TModel> reader, String name, Option<String> language) {
        PipelineStage pipelineStage;
        ResourceDownloader.ResourceRequest key = new ResourceDownloader.ResourceRequest(name, language);
        if (this.cache().contains((Object)key)) {
            pipelineStage = (PipelineStage)this.cache().apply((Object)key);
        } else {
            String path = this.downloadResource(name, language);
            PipelineStage model2 = (PipelineStage)reader.read().load(path);
            this.cache().update((Object)key, (Object)model2);
            pipelineStage = model2;
        }
        return (TModel)pipelineStage;
    }

    public PipelineModel downloadPipeline(String name, Option<String> language) {
        PipelineModel pipelineModel2;
        ResourceDownloader.ResourceRequest key = new ResourceDownloader.ResourceRequest(name, language);
        if (this.cache().contains((Object)key)) {
            pipelineModel2 = (PipelineModel)this.cache().apply((Object)key);
        } else {
            String path = this.downloadResource(name, language);
            PipelineModel model2 = (PipelineModel)PipelineModel$.MODULE$.read().load(path);
            this.cache().update((Object)key, (Object)model2);
            pipelineModel2 = model2;
        }
        return pipelineModel2;
    }

    public void clearCache(String name, Option<String> language) {
        this.defaultDownloader().clearCache(name, language, this.libVersion(), this.sparkVersion());
        this.cache().remove((Object)new ResourceDownloader.ResourceRequest(name, language));
    }

    private ResourceDownloader$() {
        MODULE$ = this;
        this.s3Bucket = ConfigHelper$.MODULE$.getConfigValueOrElse(ConfigHelper$.MODULE$.pretrainedS3BucketKey(), (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "data.johnsnowlabs.com";
            }
        });
        this.s3Path = ConfigHelper$.MODULE$.getConfigValueOrElse(ConfigHelper$.MODULE$.pretrainedS3PathKey(), (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "models/spark-nlp-public";
            }
        });
        this.cacheFolder = ConfigHelper$.MODULE$.getConfigValueOrElse(ConfigHelper$.MODULE$.pretrainedCacheFolder(), (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cache_pretrained";
            }
        });
        this.cache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.defaultDownloader = new CloudResourceDownloader(this.s3Bucket(), this.s3Path(), this.cacheFolder(), CloudResourceDownloader$.MODULE$.$lessinit$greater$default$4());
    }
}

