/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.util.Version;
import com.johnsnowlabs.util.Version$;
import java.io.FileWriter;
import java.io.InputStream;
import java.sql.Timestamp;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.JsonMethods$;
import org.json4s.jackson.Serialization$;
import org.json4s.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple7;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class ResourceMetadata$
implements Serializable {
    public static final ResourceMetadata$ MODULE$;
    private final Formats formats;

    static {
        new ResourceMetadata$();
    }

    public Formats formats() {
        return this.formats;
    }

    public String toJson(ResourceMetadata meta) {
        return Serialization$.MODULE$.write((Object)meta, this.formats());
    }

    public ResourceMetadata parseJson(String json) {
        JsonAST.JValue parsed = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2());
        return (ResourceMetadata)package$.MODULE$.jvalue2extractable(parsed).extract(this.formats(), ManifestFactory$.MODULE$.classType(ResourceMetadata.class));
    }

    public Option<ResourceMetadata> resolveResource(List<ResourceMetadata> candidates, String name, Option<String> language, Version libVersion, Version sparkVersion) {
        return ((TraversableLike)((SeqLike)candidates.filter((Function1)new Serializable(name, language, libVersion, sparkVersion){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Option language$1;
            private final Version libVersion$1;
            private final Version sparkVersion$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(ResourceMetadata item) {
                if (!item.readyToUse()) return false;
                String string = item.name();
                String string2 = this.name$1;
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!this.language$1.isEmpty() && !item.language().isEmpty()) {
                    if (!BoxesRunTime.equals((Object)this.language$1.get(), (Object)item.language().get())) return false;
                }
                if (!Version$.MODULE$.isCompatible(this.libVersion$1, item.libVersion())) return false;
                if (!Version$.MODULE$.isCompatible(this.sparkVersion$1, item.sparkVersion())) return false;
                return true;
            }
            {
                this.name$1 = name$1;
                this.language$1 = language$1;
                this.libVersion$1 = libVersion$1;
                this.sparkVersion$1 = sparkVersion$1;
            }
        })).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(ResourceMetadata item) {
                return item.time().getTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).lastOption();
    }

    public List<ResourceMetadata> readResources(String file) {
        return this.readResources((Source)Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()));
    }

    public List<ResourceMetadata> readResources(InputStream stream) {
        return this.readResources((Source)Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()));
    }

    public List<ResourceMetadata> readResources(Source source) {
        return source.getLines().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ResourceMetadata apply(String line) {
                return ResourceMetadata$.MODULE$.parseJson(line);
            }
        }).toList();
    }

    /*
     * WARNING - void declaration
     */
    public void addMetadataToFile(String fileName, ResourceMetadata metadata) {
        FileWriter fw = new FileWriter(fileName, true);
        try {
            fw.write(new StringBuilder().append((Object)this.toJson(metadata)).append((Object)"\n").toString());
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        fw.close();
    }

    public ResourceMetadata apply(String name, Option<String> language, Option<Version> libVersion, Option<Version> sparkVersion, boolean readyToUse, Timestamp time, boolean isZipped) {
        return new ResourceMetadata(name, language, libVersion, sparkVersion, readyToUse, time, isZipped);
    }

    public Option<Tuple7<String, Option<String>, Option<Version>, Option<Version>, Object, Timestamp, Object>> unapply(ResourceMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.name(), x$0.language(), x$0.libVersion(), x$0.sparkVersion(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.readyToUse()), (Object)x$0.time(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isZipped())));
    }

    public boolean $lessinit$greater$default$7() {
        return false;
    }

    public boolean apply$default$7() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ResourceMetadata$() {
        MODULE$ = this;
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

