/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.util.io;

import com.johnsnowlabs.nlp.DocumentAssembler;
import com.johnsnowlabs.nlp.Finisher;
import com.johnsnowlabs.nlp.HasOutputAnnotationCol;
import com.johnsnowlabs.nlp.annotators.Tokenizer;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence$;
import com.johnsnowlabs.nlp.annotators.common.TaggedWord;
import com.johnsnowlabs.nlp.util.io.ExternalResource;
import com.johnsnowlabs.nlp.util.io.ReadAs$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.CollectionAccumulator;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ResourceHelper$ {
    public static final ResourceHelper$ MODULE$;
    private final SparkSession spark;

    static {
        new ResourceHelper$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public InputStream com$johnsnowlabs$nlp$util$io$ResourceHelper$$inputStreamOrSequence(FileSystem fs, RemoteIterator<LocatedFileStatus> files) {
        LocatedFileStatus firstFile = (LocatedFileStatus)files.next();
        return files.hasNext() ? new SequenceInputStream((InputStream)fs.open(firstFile.getPath()), this.com$johnsnowlabs$nlp$util$io$ResourceHelper$$inputStreamOrSequence(fs, files)) : fs.open(firstFile.getPath());
    }

    public String com$johnsnowlabs$nlp$util$io$ResourceHelper$$fixTarget(String path) {
        String toSearch = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^.*target\\\\", ".*scala-.*\\\\", ".*classes\\\\", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{File.separator, File.separator, File.separator}));
        return path.matches(new StringBuilder().append((Object)toSearch).append((Object)".*").toString()) ? path.replaceFirst(toSearch, "") : path;
    }

    public InputStream getResourceStream(String path) {
        return (InputStream)Option$.MODULE$.apply((Object)this.getClass().getResourceAsStream(path)).getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final InputStream apply() {
                return ResourceHelper$.MODULE$.getClass().getClassLoader().getResourceAsStream(this.path$1);
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public URL getResourceFile(String path) {
        void var2_2;
        URL dirURL = this.getClass().getResource(path);
        if (dirURL == null) {
            dirURL = this.getClass().getClassLoader().getResource(path);
        }
        return var2_2;
    }

    public Seq<String> listResourceDirectory(String path) {
        URL dirURL = this.getResourceFile(path);
        System.out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listDirectory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dirURL})));
        if (dirURL != null && dirURL.getProtocol().equals("file") && new File(dirURL.toURI()).exists()) {
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dirURL.toURI()).listFiles()).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$2) {
                    return x$2.getPath();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$3) {
                    return ResourceHelper$.MODULE$.com$johnsnowlabs$nlp$util$io$ResourceHelper$$fixTarget(x$3);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        if (dirURL == null) {
            throw new FileNotFoundException(path);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            ArrayBuffer result = new ArrayBuffer();
            String pathToCheck = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path)).stripPrefix(new StringOps(Predef$.MODULE$.augmentString(File.separator)).replaceAllLiterally("\\", "/")))).stripSuffix(File.separator)).append((Object)new StringOps(Predef$.MODULE$.augmentString(File.separator)).replaceAllLiterally("\\", "/")).toString();
            while (entries.hasMoreElements()) {
                String name = new StringOps(Predef$.MODULE$.augmentString(((ZipEntry)entries.nextElement()).getName())).stripPrefix(File.separator);
                if (!name.startsWith(pathToCheck)) continue;
                String entry = name.substring(pathToCheck.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                if (!new StringOps(Predef$.MODULE$.augmentString(entry)).nonEmpty()) continue;
                result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)pathToCheck).append((Object)entry).toString()}));
            }
            return (Seq)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot list files for URL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dirURL})));
    }

    public Dataset<?> createDatasetFromText(String path, boolean clean, boolean includeFilename, boolean includeRowNumber, boolean aggregateByFile) {
        Predef$.MODULE$.require(includeFilename && aggregateByFile || !includeFilename && !aggregateByFile, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "AggregateByFile requires includeFileName";
            }
        });
        Dataset data = this.spark().read().textFile(path);
        if (clean) {
            data = data.as(this.spark().implicits().newStringEncoder()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$4) {
                    return x$4.trim();
                }
            }, this.spark().implicits().newStringEncoder()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
                }
            });
        }
        if (includeFilename) {
            data = data.withColumn("filename", functions$.MODULE$.input_file_name());
        }
        if (aggregateByFile) {
            data = data.groupBy("filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.collect_list((Column)this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("value"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).withColumn("text", functions$.MODULE$.concat_ws(" ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)}))).drop("value");
        }
        if (includeRowNumber) {
            if (includeFilename && !aggregateByFile) {
                WindowSpec w = Window$.MODULE$.partitionBy("filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                data = data.withColumn("id", functions$.MODULE$.row_number().over(w));
            } else {
                data = data.withColumn("id", functions$.MODULE$.monotonically_increasing_id());
            }
        }
        return data.withColumnRenamed("value", "text");
    }

    public boolean createDatasetFromText$default$2() {
        return true;
    }

    public boolean createDatasetFromText$default$3() {
        return false;
    }

    public boolean createDatasetFromText$default$4() {
        return false;
    }

    public boolean createDatasetFromText$default$5() {
        return false;
    }

    public Map<String, String> parseKeyValueText(ExternalResource er) {
        block4: {
            Map map;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    Map res = sourceStream.content().getLines().map((Function1)new Serializable(er){
                        public static final long serialVersionUID = 0L;
                        private final ExternalResource er$1;

                        public final Tuple2<String, String> apply(String line) {
                            String[] kv = (String[])Predef$.MODULE$.refArrayOps((Object[])line.split((String)this.er$1.options().apply((Object)"delimiter"))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$6) {
                                    return x$6.trim();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])kv).head(), Predef$.MODULE$.refArrayOps((Object[])kv).last());
                        }
                        {
                            this.er$1 = er$1;
                        }
                    }).toMap(Predef$.MODULE$.$conforms());
                    sourceStream.close();
                    map = res;
                    break block3;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).options(er.options()).option("delimiter", (String)er.options().apply((Object)"delimiter")).load(er.path()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
                scala.collection.mutable.Map keyValueStore = Map$.MODULE$.empty();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator10$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
                    }

                    public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator10$1() {
                    }
                }
                dataset.as(this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator10$1()))).foreach((Function1)new Serializable(keyValueStore){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map keyValueStore$1;

                    public final void apply(Tuple2<String, String> kv) {
                        this.keyValueStore$1.update(kv._1(), kv._2());
                    }
                    {
                        this.keyValueStore$1 = keyValueStore$1;
                    }
                });
                map = keyValueStore.toMap(Predef$.MODULE$.$conforms());
            }
            return map;
        }
        throw new Exception("Unsupported readAs");
    }

    public String[] parseLines(ExternalResource er) {
        block4: {
            String[] stringArray;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    String[] res = (String[])sourceStream.content().getLines().toArray(ClassTag$.MODULE$.apply(String.class));
                    sourceStream.close();
                    stringArray = res;
                    break block3;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                CollectionAccumulator lineStore = this.spark().sparkContext().collectionAccumulator();
                dataset.as(this.spark().implicits().newStringEncoder()).foreach((Function1)new Serializable(lineStore){
                    public static final long serialVersionUID = 0L;
                    private final CollectionAccumulator lineStore$1;

                    public final void apply(String l) {
                        this.lineStore$1.add((Object)l);
                    }
                    {
                        this.lineStore$1 = lineStore$1;
                    }
                });
                String[] result = (String[])Predef$.MODULE$.refArrayOps(lineStore.value().toArray()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$7) {
                        return x$7.toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                lineStore.reset();
                stringArray = result;
            }
            return stringArray;
        }
        throw new Exception("Unsupported readAs");
    }

    public Tuple2<String, String>[] parseTupleText(ExternalResource er) {
        block4: {
            Tuple2[] tuple2Array;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    Tuple2[] res = (Tuple2[])sourceStream.content().getLines().filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$8) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
                        }
                    }).map((Function1)new Serializable(er){
                        public static final long serialVersionUID = 0L;
                        private final ExternalResource er$2;

                        public final Tuple2<String, String> apply(String line) {
                            String[] kv = (String[])Predef$.MODULE$.refArrayOps((Object[])line.split((String)this.er$2.options().apply((Object)"delimiter"))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$9) {
                                    return x$9.trim();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])kv).head(), Predef$.MODULE$.refArrayOps((Object[])kv).last());
                        }
                        {
                            this.er$2 = er$2;
                        }
                    }).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    sourceStream.close();
                    tuple2Array = res;
                    break block3;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                CollectionAccumulator lineStore = this.spark().sparkContext().collectionAccumulator();
                dataset.as(this.spark().implicits().newStringEncoder()).foreach((Function1)new Serializable(lineStore){
                    public static final long serialVersionUID = 0L;
                    private final CollectionAccumulator lineStore$2;

                    public final void apply(String l) {
                        this.lineStore$2.add((Object)l);
                    }
                    {
                        this.lineStore$2 = lineStore$2;
                    }
                });
                Tuple2[] result = (Tuple2[])Predef$.MODULE$.refArrayOps(lineStore.value().toArray()).map((Function1)new Serializable(er){
                    public static final long serialVersionUID = 0L;
                    private final ExternalResource er$2;

                    public final Tuple2<String, String> apply(Object line) {
                        String[] kv = (String[])Predef$.MODULE$.refArrayOps((Object[])line.toString().split((String)this.er$2.options().apply((Object)"delimiter"))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$10) {
                                return x$10.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])kv).head(), Predef$.MODULE$.refArrayOps((Object[])kv).last());
                    }
                    {
                        this.er$2 = er$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                lineStore.reset();
                tuple2Array = result;
            }
            return tuple2Array;
        }
        throw new Exception("Unsupported readAs");
    }

    public TaggedSentence[] parseTupleSentences(ExternalResource er) {
        block4: {
            TaggedSentence[] taggedSentenceArray;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    TaggedWord[][] result = (TaggedWord[][])sourceStream.content().getLines().filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$11) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
                        }
                    }).map((Function1)new Serializable(er){
                        public static final long serialVersionUID = 0L;
                        public final ExternalResource er$3;

                        public final TaggedWord[] apply(String line) {
                            return (TaggedWord[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.12 $outer;

                                public final boolean apply(String kv) {
                                    String[] s2 = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)this.$outer.er$3.options().apply((Object)"delimiter"))).head()));
                                    return s2.length == 2 && new StringOps(Predef$.MODULE$.augmentString(s2[0])).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s2[1])).nonEmpty();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.12 $outer;

                                public final TaggedWord apply(String kv) {
                                    String[] p = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)this.$outer.er$3.options().apply((Object)"delimiter"))).head()));
                                    return new TaggedWord(p[0], p[1]);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedWord.class)));
                        }
                        {
                            this.er$3 = er$3;
                        }
                    }).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(TaggedWord.class)));
                    sourceStream.close();
                    taggedSentenceArray = (TaggedSentence[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final TaggedSentence apply(TaggedWord[] x$12) {
                            return new TaggedSentence(x$12, TaggedSentence$.MODULE$.apply$default$2());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedSentence.class)));
                    break block3;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator20$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("com.johnsnowlabs.nlp.annotators.common.TaggedWord").asType().toTypeConstructor();
                    }

                    public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator20$1() {
                    }
                }
                TaggedWord[][] result = (TaggedWord[][])dataset.as(this.spark().implicits().newStringEncoder()).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$13) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$13)).nonEmpty();
                    }
                }).map((Function1)new Serializable(er){
                    public static final long serialVersionUID = 0L;
                    public final ExternalResource er$3;

                    public final TaggedWord[] apply(String line) {
                        return (TaggedWord[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.14 $outer;

                            public final boolean apply(String kv) {
                                String[] s2 = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)this.$outer.er$3.options().apply((Object)"delimiter"))).head()));
                                return s2.length == 2 && new StringOps(Predef$.MODULE$.augmentString(s2[0])).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s2[1])).nonEmpty();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.14 $outer;

                            public final TaggedWord apply(String kv) {
                                String[] p = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)this.$outer.er$3.options().apply((Object)"delimiter"))).head()));
                                return new TaggedWord(p[0], p[1]);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedWord.class)));
                    }
                    {
                        this.er$3 = er$3;
                    }
                }, this.spark().implicits().newProductArrayEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator20$1()))).collect();
                taggedSentenceArray = (TaggedSentence[])Predef$.MODULE$.refArrayOps((Object[])result).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TaggedSentence apply(TaggedWord[] x$14) {
                        return new TaggedSentence(x$14, TaggedSentence$.MODULE$.apply$default$2());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedSentence.class)));
            }
            return taggedSentenceArray;
        }
        throw new Exception("Unsupported readAs");
    }

    public Map<String, String> flattenRevertValuesAsKeys(ExternalResource er) {
        block4: {
            Map map;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    sourceStream.content().getLines().foreach((Function1)new Serializable(er, m){
                        public static final long serialVersionUID = 0L;
                        private final ExternalResource er$4;
                        public final scala.collection.mutable.Map m$1;

                        public final void apply(String line) {
                            String[] kv = (String[])Predef$.MODULE$.refArrayOps((Object[])line.split((String)this.er$4.options().apply((Object)"keyDelimiter"))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$15) {
                                    return x$15.trim();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            String key = kv[0];
                            String[] values = (String[])Predef$.MODULE$.refArrayOps((Object[])kv[1].split((String)this.er$4.options().apply((Object)"valueDelimiter"))).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$16) {
                                    return x$16.trim();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            Predef$.MODULE$.refArrayOps((Object[])values).foreach((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.flattenRevertValuesAsKeys.1 $outer;
                                private final String key$1;

                                public final void apply(String x$17) {
                                    this.$outer.m$1.update((Object)x$17, (Object)this.key$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                }
                            });
                        }
                        {
                            this.er$4 = er$4;
                            this.m$1 = m$1;
                        }
                    });
                    sourceStream.close();
                    map = m.toMap(Predef$.MODULE$.$conforms());
                    break block3;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                scala.collection.mutable.Map valueAsKeys = Map$.MODULE$.empty();
                dataset.as(this.spark().implicits().newStringEncoder()).foreach((Function1)new Serializable(er, valueAsKeys){
                    public static final long serialVersionUID = 0L;
                    private final ExternalResource er$4;
                    public final scala.collection.mutable.Map valueAsKeys$1;

                    public final void apply(String line) {
                        String[] kv = (String[])Predef$.MODULE$.refArrayOps((Object[])line.split((String)this.er$4.options().apply((Object)"keyDelimiter"))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$18) {
                                return x$18.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        String key = kv[0];
                        String[] values = (String[])Predef$.MODULE$.refArrayOps((Object[])kv[1].split((String)this.er$4.options().apply((Object)"valueDelimiter"))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$19) {
                                return x$19.trim();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        Predef$.MODULE$.refArrayOps((Object[])values).foreach((Function1)new Serializable(this, key){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.flattenRevertValuesAsKeys.2 $outer;
                            private final String key$2;

                            public final void apply(String v2) {
                                this.$outer.valueAsKeys$1.update((Object)v2, (Object)this.key$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.key$2 = key$2;
                            }
                        });
                    }
                    {
                        this.er$4 = er$4;
                        this.valueAsKeys$1 = valueAsKeys$1;
                    }
                });
                map = valueAsKeys.toMap(Predef$.MODULE$.$conforms());
            }
            return map;
        }
        throw new Exception("Unsupported readAs");
    }

    public scala.collection.mutable.Map<String, Object> wordCount(ExternalResource er, scala.collection.mutable.Map<String, Object> m, Option<PipelineModel> p) {
        block8: {
            scala.collection.mutable.Map map;
            block7: {
                Dataset dataset;
                Enumeration.Value value;
                block6: {
                    value = er.readAs();
                    Enumeration.Value value2 = ReadAs$.MODULE$.LINE_BY_LINE();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block6;
                    ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString((String)er.options().apply((Object)"tokenPattern"))).r();
                    sourceStream.content().getLines().foreach((Function1)new Serializable(m, regex){
                        public static final long serialVersionUID = 0L;
                        public final scala.collection.mutable.Map m$2;
                        private final Regex regex$1;

                        public final void apply(String line) {
                            List words = this.regex$1.findAllMatchIn((CharSequence)line).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Regex.Match x$20) {
                                    return x$20.matched();
                                }
                            }).toList();
                            words.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.wordCount.1 $outer;

                                public final void apply(String w) {
                                    this.$outer.m$2.update((Object)w, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.$outer.m$2.apply((Object)w)) + 1L)));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.m$2 = m$2;
                            this.regex$1 = regex$1;
                        }
                    });
                    sourceStream.close();
                    if (m.isEmpty()) {
                        throw new FileNotFoundException("Word count dictionary for spell checker does not exist or is empty");
                    }
                    map = m;
                    break block7;
                }
                Enumeration.Value value4 = ReadAs$.MODULE$.SPARK_DATASET();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block8;
                Dataset dataset2 = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                if (p.isDefined()) {
                    dataset = ((PipelineModel)p.get()).transform(dataset2);
                } else {
                    DocumentAssembler documentAssembler = new DocumentAssembler().setInputCol("value");
                    Tokenizer tokenizer = ((Tokenizer)((HasOutputAnnotationCol)((Object)new Tokenizer().setInputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"document"})))).setOutputCol("token")).setTargetPattern((String)er.options().apply((Object)"tokenPattern"));
                    Finisher finisher = new Finisher().setInputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"token"})).setOutputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"finished"})).setAnnotationSplitSymbol("--");
                    dataset = new Pipeline().setStages((PipelineStage[])new Transformer[]{documentAssembler, tokenizer, finisher}).fit(dataset2).transform(dataset2);
                }
                Dataset transformation = dataset;
                scala.collection.mutable.Map wordCount2 = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
                transformation.select("finished", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.spark().implicits().newStringEncoder()).foreach((Function1)new Serializable(wordCount2){
                    public static final long serialVersionUID = 0L;
                    public final scala.collection.mutable.Map wordCount$1;

                    public final void apply(String text) {
                        Predef$.MODULE$.refArrayOps((Object[])text.split("--")).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.wordCount.2 $outer;

                            public final void apply(String t) {
                                this.$outer.wordCount$1.update((Object)t, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.$outer.wordCount$1.apply((Object)t)) + 1L)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.wordCount$1 = wordCount$1;
                    }
                });
                map = wordCount2;
            }
            return map;
        }
        throw new IllegalArgumentException("format not available for word count");
    }

    public scala.collection.mutable.Map<String, Object> wordCount$default$2() {
        return Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
    }

    public Option<PipelineModel> wordCount$default$3() {
        return None$.MODULE$;
    }

    private ResourceHelper$() {
        MODULE$ = this;
        this.spark = SparkSession$.MODULE$.builder().getOrCreate();
    }
}

