/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.util;

import com.johnsnowlabs.util.ZipArchiveUtil$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ZipArchiveUtil$ {
    public static final ZipArchiveUtil$ MODULE$;

    static {
        new ZipArchiveUtil$();
    }

    public List<String> com$johnsnowlabs$util$ZipArchiveUtil$$listFiles(File file, String outputFilename) {
        block4: {
            Nil$ nil$;
            block3: {
                File file2;
                block2: {
                    file2 = file;
                    if (!file2.isFile()) break block2;
                    String string = file2.getName();
                    String string2 = outputFilename;
                    nil$ = !(string != null ? !string.equals(string2) : string2 != null) ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file2.getAbsoluteFile().toString()}));
                    break block3;
                }
                if (!file2.isDirectory()) break block4;
                String[] fList = file2.list();
                nil$ = (List)Predef$.MODULE$.refArrayOps((Object[])fList).foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(outputFilename, file2){
                    public static final long serialVersionUID = 0L;
                    private final String outputFilename$1;
                    private final File x1$1;

                    public final List<String> apply(List<String> pList, String path) {
                        return (List)pList.$plus$plus(ZipArchiveUtil$.MODULE$.com$johnsnowlabs$util$ZipArchiveUtil$$listFiles(new File(this.x1$1, path), this.outputFilename$1), List$.MODULE$.canBuildFrom());
                    }
                    {
                        this.outputFilename$1 = outputFilename$1;
                        this.x1$1 = x1$1;
                    }
                });
            }
            return nil$;
        }
        throw new IOException("Bad path. No file or directory found.");
    }

    public ZipEntry com$johnsnowlabs$util$ZipArchiveUtil$$addFileToZipEntry(String filename, String parentPath, int filePathsCount) {
        ZipEntry zipEntry;
        if (filePathsCount <= 1) {
            zipEntry = new ZipEntry(new File(filename).getName());
        } else {
            String relative = new File(parentPath).toURI().relativize(new File(filename).toURI()).getPath();
            zipEntry = new ZipEntry(relative);
        }
        return zipEntry;
    }

    private void createZip(List<String> filePaths, String outputFilename, String parentPath) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(outputFilename);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            filePaths.foreach((Function1)new Serializable(filePaths, parentPath, zipOutputStream){
                public static final long serialVersionUID = 0L;
                private final List filePaths$1;
                private final String parentPath$1;
                public final ZipOutputStream zipOutputStream$1;

                public final void apply(String name) {
                    ZipEntry zipEntry = ZipArchiveUtil$.MODULE$.com$johnsnowlabs$util$ZipArchiveUtil$$addFileToZipEntry(name, this.parentPath$1, this.filePaths$1.size());
                    this.zipOutputStream$1.putNextEntry(zipEntry);
                    BufferedSource inputSrc = new BufferedSource((InputStream)new FileInputStream(name), Codec$.MODULE$.ISO8859());
                    inputSrc.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createZip.1 $outer;

                        public final void apply(char c) {
                            this.$outer.zipOutputStream$1.write(c);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    inputSrc.close();
                }
                {
                    this.filePaths$1 = filePaths$1;
                    this.parentPath$1 = parentPath$1;
                    this.zipOutputStream$1 = zipOutputStream$1;
                }
            });
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void zip(String fileName, String outputFileName) {
        File file = new File(fileName);
        List<String> filePaths = this.com$johnsnowlabs$util$ZipArchiveUtil$$listFiles(file, outputFileName);
        this.createZip(filePaths, outputFileName, fileName);
    }

    public String unzip(File file, Option<String> destDirPath) {
        String fileName = file.getName();
        String basename = fileName.indexOf(46) >= 0 ? fileName.substring(0, fileName.lastIndexOf(".")) : new StringBuilder().append((Object)fileName).append((Object)"_unzipped").toString();
        Option<String> option = destDirPath;
        None$ none$ = None$.MODULE$;
        File destDir = !(option != null ? !option.equals((Object)none$) : none$ != null) ? new File(file.getParentFile(), basename) : new File((String)destDirPath.get());
        destDir.mkdirs();
        ZipFile zip = new ZipFile(file);
        JavaConversions$.MODULE$.enumerationAsScalaIterator(zip.entries()).foreach((Function1)new Serializable(basename, destDir, zip){
            public static final long serialVersionUID = 0L;
            private final String basename$1;
            private final File destDir$1;
            private final ZipFile zip$1;

            public final void apply(ZipEntry entry) {
                String entryName = entry.getName();
                String entryPath = entryName.startsWith(this.basename$1) ? entryName.substring(this.basename$1.length()) : entryName;
                String[] splitPath = (String[])Predef$.MODULE$.refArrayOps((Object[])entryName.split(File.separator.replace("\\", "/"))).dropRight(1);
                StringBuilder dirBuilder = new StringBuilder(this.destDir$1.getPath());
                Predef$.MODULE$.refArrayOps((Object[])splitPath).foreach((Function1)new Serializable(this, dirBuilder){
                    public static final long serialVersionUID = 0L;
                    private final StringBuilder dirBuilder$1;

                    public final Object apply(String part) {
                        this.dirBuilder$1.append(File.separator);
                        this.dirBuilder$1.append(part);
                        String path = this.dirBuilder$1.toString();
                        return new File(path).exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)new File(path).mkdir());
                    }
                    {
                        this.dirBuilder$1 = dirBuilder$1;
                    }
                });
                FileUtils.copyInputStreamToFile((InputStream)this.zip$1.getInputStream(entry), (File)new File(this.destDir$1, entryPath));
            }
            {
                this.basename$1 = basename$1;
                this.destDir$1 = destDir$1;
                this.zip$1 = zip$1;
            }
        });
        return destDir.getPath();
    }

    public Option<String> unzip$default$2() {
        return None$.MODULE$;
    }

    private ZipArchiveUtil$() {
        MODULE$ = this;
    }
}

