/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class LogMessage
implements Comparable<LogMessage> {
    private long timestamp;
    private byte[] messageBytes;

    public static LogMessage create(String message) {
        try {
            return new LogMessage(System.currentTimeMillis(), message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LogLog.error((String)"unsupported encoding: UTF-8 (should never happen!)");
            return null;
        }
    }

    public static LogMessage create(LoggingEvent event, Layout layout) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            out.write(layout.format(event));
            if (event.getThrowableInformation() != null && layout.ignoresThrowable()) {
                for (String traceline : event.getThrowableStrRep()) {
                    out.write(traceline);
                    out.write(Layout.LINE_SEP);
                }
            }
            out.close();
            return new LogMessage(event.getTimeStamp(), bos.toByteArray());
        }
        catch (Exception ex) {
            LogLog.error((String)"error creating LogMessage (should never happen!)", (Throwable)ex);
            return null;
        }
    }

    public LogMessage(long timestamp, byte[] messageBytes) {
        this.timestamp = timestamp;
        this.messageBytes = messageBytes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int size() {
        return this.messageBytes.length + 26;
    }

    public String getMessage() {
        try {
            return new String(this.messageBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("caught UnsupportedEncodingException for UTF-8; should never happen!");
        }
    }

    @Override
    public int compareTo(LogMessage that) {
        return this.timestamp < that.timestamp ? -1 : (this.timestamp > that.timestamp ? 1 : 0);
    }
}

