/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.documentlibrary.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the DLFileEntryMetadata service. Represents a row in the &quot;DLFileEntryMetadata&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileEntryMetadata
 * @see com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataImpl
 * @see com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataModelImpl
 * @generated
 */
public interface DLFileEntryMetadataModel extends BaseModel<DLFileEntryMetadata> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a document library file entry metadata model instance should use the {@link DLFileEntryMetadata} interface instead.
	 */

	/**
	 * Returns the primary key of this document library file entry metadata.
	 *
	 * @return the primary key of this document library file entry metadata
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this document library file entry metadata.
	 *
	 * @param primaryKey the primary key of this document library file entry metadata
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this document library file entry metadata.
	 *
	 * @return the uuid of this document library file entry metadata
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this document library file entry metadata.
	 *
	 * @param uuid the uuid of this document library file entry metadata
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the file entry metadata ID of this document library file entry metadata.
	 *
	 * @return the file entry metadata ID of this document library file entry metadata
	 */
	public long getFileEntryMetadataId();

	/**
	 * Sets the file entry metadata ID of this document library file entry metadata.
	 *
	 * @param fileEntryMetadataId the file entry metadata ID of this document library file entry metadata
	 */
	public void setFileEntryMetadataId(long fileEntryMetadataId);

	/**
	 * Returns the d d m storage ID of this document library file entry metadata.
	 *
	 * @return the d d m storage ID of this document library file entry metadata
	 */
	public long getDDMStorageId();

	/**
	 * Sets the d d m storage ID of this document library file entry metadata.
	 *
	 * @param DDMStorageId the d d m storage ID of this document library file entry metadata
	 */
	public void setDDMStorageId(long DDMStorageId);

	/**
	 * Returns the d d m structure ID of this document library file entry metadata.
	 *
	 * @return the d d m structure ID of this document library file entry metadata
	 */
	public long getDDMStructureId();

	/**
	 * Sets the d d m structure ID of this document library file entry metadata.
	 *
	 * @param DDMStructureId the d d m structure ID of this document library file entry metadata
	 */
	public void setDDMStructureId(long DDMStructureId);

	/**
	 * Returns the file entry type ID of this document library file entry metadata.
	 *
	 * @return the file entry type ID of this document library file entry metadata
	 */
	public long getFileEntryTypeId();

	/**
	 * Sets the file entry type ID of this document library file entry metadata.
	 *
	 * @param fileEntryTypeId the file entry type ID of this document library file entry metadata
	 */
	public void setFileEntryTypeId(long fileEntryTypeId);

	/**
	 * Returns the file entry ID of this document library file entry metadata.
	 *
	 * @return the file entry ID of this document library file entry metadata
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this document library file entry metadata.
	 *
	 * @param fileEntryId the file entry ID of this document library file entry metadata
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the file version ID of this document library file entry metadata.
	 *
	 * @return the file version ID of this document library file entry metadata
	 */
	public long getFileVersionId();

	/**
	 * Sets the file version ID of this document library file entry metadata.
	 *
	 * @param fileVersionId the file version ID of this document library file entry metadata
	 */
	public void setFileVersionId(long fileVersionId);

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public Serializable getPrimaryKeyObj();

	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(DLFileEntryMetadata dlFileEntryMetadata);

	public int hashCode();

	public CacheModel<DLFileEntryMetadata> toCacheModel();

	public DLFileEntryMetadata toEscapedModel();

	public String toString();

	public String toXmlString();
}