/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.servicebus;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters supplied to the Regenerate Authorization Rule operation.
 */
public class RegenerateKeysParameters {
    /**
     * Key that needs to be regenerated. Possible values include: 'PrimaryKey',
     * 'SecondaryKey'.
     */
    @JsonProperty(value = "policykey")
    private Policykey policykey;

    /**
     * Get the policykey value.
     *
     * @return the policykey value
     */
    public Policykey policykey() {
        return this.policykey;
    }

    /**
     * Set the policykey value.
     *
     * @param policykey the policykey value to set
     * @return the RegenerateKeysParameters object itself.
     */
    public RegenerateKeysParameters withPolicykey(Policykey policykey) {
        this.policykey = policykey;
        return this;
    }

}
