/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DeploymentBuildStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.ErrorEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DeployWebAppTask
extends AzureTask<WebAppBase<?, ?, ?>> {
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker webapp, you can navigate to %s to access your docker webapp.";
    private static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private static final String START_APP_DONE = "Successfully started Web App.";
    private static final int DEFAULT_DEPLOYMENT_STATUS_REFRESH_INTERVAL = 10;
    private static final int DEFAULT_DEPLOYMENT_STATUS_MAX_REFRESH_TIMES = 20;
    private final WebAppBase<?, ?, ?> webApp;
    private final List<WebAppArtifact> artifacts;
    private final boolean restartSite;
    private final boolean openStreamingLogOnFailure;
    private final Boolean waitDeploymentComplete;
    private final IAzureMessager messager;
    private Disposable subscription;
    private AtomicReference<KuduDeploymentResult> deploymentResultAtomicReference = new AtomicReference();
    private long deploymentStatusRefreshInterval = 10L;
    private long deploymentStatusMaxRefreshTimes = 20L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts) {
        this(webApp, artifacts, false);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite) {
        this(webApp, artifacts, restartSite, null, false);
    }

    public DeployWebAppTask(WebAppBase<?, ?, ?> webApp, List<WebAppArtifact> artifacts, boolean restartSite, Boolean waitDeploymentComplete, boolean openStreamingLogOnFailure) {
        this.webApp = webApp;
        this.artifacts = artifacts;
        this.restartSite = restartSite;
        this.waitDeploymentComplete = waitDeploymentComplete;
        this.openStreamingLogOnFailure = openStreamingLogOnFailure;
        this.messager = AzureMessager.getMessager();
    }

    @AzureOperation(name="internal/webapp.deploy_app.app", params={"this.webApp.getName()"})
    public WebAppBase<?, ?, ?> doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            WebAppBase<?, ?, ?> webAppBase;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.webApp.getRuntime().isDocker()) {
                this.messager.info(AzureString.format((String)SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE, (Object[])new Object[]{"https://" + this.webApp.getHostName()}));
                webAppBase = this.webApp;
            } else {
                this.messager.info(String.format(DEPLOY_START, this.webApp.getName()));
                this.deployArtifacts();
                this.messager.info(String.format(DEPLOY_FINISH, this.webApp.getHostName()));
                DeployWebAppTask.startAppService(this.webApp);
                webAppBase = this.webApp;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppBase;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deployArtifacts() {
        if (this.artifacts.stream().anyMatch(artifact -> artifact.getDeployType() == null)) {
            throw new AzureToolkitRuntimeException("missing deployment type for some artifacts.");
        }
        long startTime = System.currentTimeMillis();
        List<WebAppArtifact> artifactsOneDeploy = this.artifacts.stream().filter(artifact -> artifact.getDeployType() != null).collect(Collectors.toList());
        artifactsOneDeploy.forEach(resource -> this.deploymentResultAtomicReference.set(this.webApp.pushDeploy(resource.getDeployType(), resource.getFile(), DeployOptions.builder().path(resource.getPath()).restartSite(this.restartSite).trackDeployment(true).build())));
        if (!this.waitUntilDeploymentReady(this.deploymentStatusRefreshInterval, this.deploymentStatusMaxRefreshTimes)) {
            this.startStreamingLog();
        }
        OperationContext.action().setTelemetryProperty("deploy-cost", String.valueOf(System.currentTimeMillis() - startTime));
    }

    public boolean waitUntilDeploymentReady(long deploymentStatusRefreshInterval, long deploymentStatusMaxRefreshTimes) {
        if (!this.isTrackDeploymentStatusSupported()) {
            return false;
        }
        KuduDeploymentResult kuduDeploymentResult = this.deploymentResultAtomicReference.get();
        if (kuduDeploymentResult == null) {
            return false;
        }
        CsmDeploymentStatus status = (CsmDeploymentStatus)Mono.fromCallable(() -> this.getDeploymentStatus(this.webApp, kuduDeploymentResult)).delayElement(Duration.ofSeconds(deploymentStatusRefreshInterval)).subscribeOn(Schedulers.boundedElastic()).repeat(deploymentStatusMaxRefreshTimes).takeUntil(csmDeploymentStatus -> !csmDeploymentStatus.getStatus().isRunning()).blockLast();
        DeploymentBuildStatus buildStatus = status.getStatus();
        if (buildStatus.isSucceed()) {
            return true;
        }
        if (buildStatus.isTimeout()) {
            AzureMessager.getMessager().warning("Resource deployed, but failed to get the deployment status as timeout");
        } else if (buildStatus.isRunning()) {
            AzureMessager.getMessager().warning("Resource deployed, but the deployment is still in process in Azure");
        } else if (buildStatus.isFailed()) {
            String errorMessages = CollectionUtils.isNotEmpty(status.getErrors()) ? status.getErrors().stream().map(ErrorEntity::getMessage).collect(Collectors.joining("\n")) : "";
            String failedInstancesLogs = CollectionUtils.isEmpty(status.getFailedInstancesLogs()) ? StringUtils.join(status.getFailedInstancesLogs(), (String)"\n") : "";
            throw new AzureToolkitRuntimeException(String.format("Failed to start app %s. %s %s", this.webApp.getName(), errorMessages, failedInstancesLogs));
        }
        return false;
    }

    private boolean isTrackDeploymentStatusSupported() {
        if (BooleanUtils.isTrue((Boolean)this.waitDeploymentComplete) && this.webApp.getFormalStatus().isStopped()) {
            this.messager.info("Skip waiting deployment status for stopped web app.");
            return false;
        }
        if (BooleanUtils.isTrue((Boolean)this.waitDeploymentComplete) && this.webApp.getRuntime().isWindows()) {
            this.messager.warning("`waitDeploymentComplete` is not supported in Windows runtime, skip waiting for deployment status.");
            return false;
        }
        return Optional.ofNullable(this.waitDeploymentComplete).orElse(this.webApp.getRuntime().isLinux());
    }

    private CsmDeploymentStatus getDeploymentStatus(WebAppBase<?, ?, ?> target, KuduDeploymentResult result) {
        CsmDeploymentStatus deploymentStatus = target.getDeploymentStatus(result.getDeploymentId());
        if (Objects.isNull(deploymentStatus)) {
            return null;
        }
        String statusMessage = String.format("Deployment Status: %s; Successful Instance Count: %s; In-progress Instance Count: %s; Failed Instance Count: %s", deploymentStatus.getStatus().getValue(), deploymentStatus.getNumberOfInstancesSuccessful(), deploymentStatus.getNumberOfInstancesInProgress(), deploymentStatus.getNumberOfInstancesFailed());
        this.messager.info(statusMessage);
        return deploymentStatus;
    }

    private static void startAppService(WebAppBase<?, ?, ?> target) {
        if (!target.getFormalStatus().isRunning()) {
            AzureMessager.getMessager().info(START_APP);
            target.start();
            AzureMessager.getMessager().info(START_APP_DONE);
        }
    }

    private void startStreamingLog() {
        if (!this.webApp.isStreamingLogSupported() || !this.openStreamingLogOnFailure) {
            return;
        }
        this.messager.info(AzureString.format((String)"Opening streaming log of app({0})...", (Object[])new Object[]{this.webApp.getName()}));
        this.messager.debug("###############STREAMING LOG BEGIN##################");
        this.subscription = this.webApp.streamAllLogsAsync().doFinally(type -> this.messager.debug("###############STREAMING LOG END##################")).subscribe(arg_0 -> ((IAzureMessager)this.messager).debug(arg_0));
        try {
            TimeUnit.MINUTES.sleep(1L);
        }
        catch (Exception exception) {
        }
        finally {
            this.stopStreamingLog();
        }
    }

    private synchronized void stopStreamingLog() {
        if (this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }

    public void setDeploymentStatusRefreshInterval(long deploymentStatusRefreshInterval) {
        this.deploymentStatusRefreshInterval = deploymentStatusRefreshInterval;
    }

    public void setDeploymentStatusMaxRefreshTimes(long deploymentStatusMaxRefreshTimes) {
        this.deploymentStatusMaxRefreshTimes = deploymentStatusMaxRefreshTimes;
    }

    static {
        DeployWebAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployWebAppTask.java", DeployWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase"), 77);
    }
}

