/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.form;

import com.microsoft.azure.toolkit.lib.common.form.AzureFormInput;
import com.microsoft.azure.toolkit.lib.common.form.AzureValidationInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface AzureForm<T>
extends AzureFormInput<T> {
    @Override
    public T getValue();

    @Override
    public void setValue(T var1);

    @Override
    @Nonnull
    default public AzureValidationInfo validateInternal(T value) {
        AzureValidationInfo info = this.getValidationInfo();
        this.setValidationInfo(info);
        return info;
    }

    default public List<AzureValidationInfo> validateAllInputs() {
        return (List)this.validateAllInputsAsync().collectList().block();
    }

    default public Flux<AzureValidationInfo> validateAllInputsAsync() {
        return Flux.fromIterable(this.getInputs()).flatMap(i -> i.validateValueAsync().flux()).concatWith((Publisher)Flux.fromIterable(this.validateAdditionalInfo()));
    }

    default public List<AzureValidationInfo> getAllValidationInfos(boolean revalidateIfNone) {
        return Stream.concat(this.getInputs().stream().map(input -> input.getValidationInfo(revalidateIfNone)), this.validateAdditionalInfo().stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    default public AzureValidationInfo getValidationInfo() {
        return Stream.concat(this.getInputs().stream().map(input -> input.getValidationInfo(true)), this.validateAdditionalInfo().stream()).filter(i -> i.getType() != AzureValidationInfo.Type.SUCCESS).min(Comparator.comparing(AzureValidationInfo::getType)).orElse(AzureValidationInfo.ok(this));
    }

    @Override
    default public boolean needValidation() {
        return CollectionUtils.isNotEmpty(this.getInputs());
    }

    public List<AzureFormInput<?>> getInputs();

    default public List<AzureValidationInfo> validateAdditionalInfo() {
        return Collections.emptyList();
    }
}

