/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureTelemetryClient {
    public static final String ARCH_KEY = "arch";
    public static final String JDK_KEY = "jdk";
    private static final String[] SYSTEM_PROPERTIES = new String[]{"resourceType"};
    private static final String FILE_PATH_REGEX = "(file://)?([a-zA-Z]:(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._]+(\\\\\\\\|\\\\|/))+[\\w-._]*";
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(file://)?([a-zA-Z]:(\\\\\\\\|\\\\|/)|(\\\\\\\\|\\\\|/))?([\\w-._]+(\\\\\\\\|\\\\|/))+[\\w-._]*");
    private static final Pattern GOOGLE_API_KEY = Pattern.compile("AIza[a-zA-Z0-9_\\\\-]{35}");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-]+");
    private static final Pattern SECRET_PATTERN = Pattern.compile("(key|token|sig|secret|signature|password|passwd|pwd|android:value)[^a-zA-Z0-9]", 2);
    private static final Pattern TOKEN_REGEX = Pattern.compile("xox[pbar]-[a-zA-Z0-9]", 2);
    private static final Map<Pattern, String> PATTERN_MAP = new HashMap<Pattern, String>(){
        {
            this.put(EMAIL_PATTERN, "<REDACTED: Email>");
            this.put(SECRET_PATTERN, "<REDACTED: Generic Secret>");
            this.put(TOKEN_REGEX, "<REDACTED: Slack Toke>");
            this.put(GOOGLE_API_KEY, "<REDACTED: Google API Key>");
        }
    };
    private final TelemetryClient client = new TelemetryClient();
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private boolean isEnabled = true;

    public AzureTelemetryClient() {
        this(Collections.emptyMap());
    }

    public AzureTelemetryClient(@Nonnull Map<String, String> defaultProperties) {
        this.initDefaultProperties();
        this.defaultProperties.putAll(defaultProperties);
    }

    public void addDefaultProperty(@Nonnull String key, @Nonnull String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.defaultProperties.put(key, value);
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
    }

    public void trackEvent(@Nonnull String eventName) {
        this.trackEvent(eventName, null, null, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties) {
        this.trackEvent(eventName, customProperties, null, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties, @Nullable Map<String, Double> metrics) {
        this.trackEvent(eventName, customProperties, metrics, false);
    }

    public void trackEvent(@Nonnull String eventName, @Nullable Map<String, String> customProperties, @Nullable Map<String, Double> metrics, boolean overrideDefaultProperties) {
        if (!this.isEnabled()) {
            return;
        }
        Map<String, String> properties = this.mergeProperties(this.getDefaultProperties(), customProperties, overrideDefaultProperties);
        properties.entrySet().removeIf(stringStringEntry -> StringUtils.isEmpty((CharSequence)((CharSequence)stringStringEntry.getValue())));
        AzureTelemetryClient.anonymizePersonallyIdentifiableInformation(properties);
        this.client.trackEvent(eventName, properties, metrics);
        this.client.flush();
    }

    protected Map<String, String> mergeProperties(Map<String, String> defaultProperties, Map<String, String> customProperties, boolean overrideDefaultProperties) {
        if (customProperties == null) {
            return defaultProperties;
        }
        HashMap<String, String> merged = new HashMap<String, String>();
        if (overrideDefaultProperties) {
            merged.putAll(defaultProperties);
            merged.putAll(customProperties);
        } else {
            merged.putAll(customProperties);
            merged.putAll(defaultProperties);
        }
        return merged;
    }

    protected static void anonymizePersonallyIdentifiableInformation(Map<String, String> properties) {
        properties.replaceAll((key, value) -> {
            if (StringUtils.isBlank((CharSequence)value) || StringUtils.equalsAnyIgnoreCase((CharSequence)key, (CharSequence[])SYSTEM_PROPERTIES)) {
                return value;
            }
            return Arrays.stream(value.split("\\r?\\n")).map(line -> {
                String input = FILE_PATH_PATTERN.matcher((CharSequence)line).replaceAll("<REDACTED: user-file-path>");
                for (Pattern pattern : PATTERN_MAP.keySet()) {
                    if (!pattern.matcher(input).find()) continue;
                    return PATTERN_MAP.get(pattern);
                }
                return input;
            }).collect(Collectors.joining("\n"));
        });
    }

    private void initDefaultProperties() {
        this.addDefaultProperty(ARCH_KEY, System.getProperty("os.arch"));
        this.addDefaultProperty(JDK_KEY, System.getProperty("java.version"));
    }

    public TelemetryClient getClient() {
        return this.client;
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }
}

