/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.common;

import com.microsoft.azure.flink.common.Version;
import com.microsoft.azure.flink.config.KustoConnectionOptions;
import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.ClientFactory;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.ingest.IngestClient;
import com.microsoft.azure.kusto.ingest.IngestClientFactory;
import com.microsoft.azure.kusto.ingest.QueuedIngestClient;
import java.net.URISyntaxException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class KustoClientUtil {
    public static IngestClient createIngestClient(KustoConnectionOptions connectionOptions, String sourceClass) throws URISyntaxException {
        return IngestClientFactory.createClient((ConnectionStringBuilder)KustoClientUtil.getIngestKcsb(connectionOptions, sourceClass, "ingest"));
    }

    public static QueuedIngestClient createDMClient(KustoConnectionOptions connectionOptions, String sourceClass) throws URISyntaxException {
        return IngestClientFactory.createClient((ConnectionStringBuilder)KustoClientUtil.getIngestKcsb(connectionOptions, sourceClass, "dm"));
    }

    public static IngestClient createMangedIngestClient(KustoConnectionOptions connectionOptions, String sourceClass) throws URISyntaxException {
        return IngestClientFactory.createManagedStreamingIngestClient((ConnectionStringBuilder)KustoClientUtil.getIngestKcsb(connectionOptions, sourceClass, "ingest"));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Client createClient(KustoConnectionOptions connectionOptions, String sourceClass) throws URISyntaxException {
        return ClientFactory.createClient((ConnectionStringBuilder)KustoClientUtil.getQueryKcsb(connectionOptions, sourceClass));
    }

    public static ConnectionStringBuilder getIngestKcsb(@NotNull KustoConnectionOptions connectionOptions, String sourceClass, String clusterType) {
        ConnectionStringBuilder kcsb = connectionOptions.isManagedIdentity() ? ("system".equalsIgnoreCase(connectionOptions.getManagedIdentityAppId()) ? ConnectionStringBuilder.createWithAadManagedIdentity((String)connectionOptions.getIngestUrl()) : ConnectionStringBuilder.createWithAadManagedIdentity((String)connectionOptions.getIngestUrl(), (String)connectionOptions.getManagedIdentityAppId())) : ConnectionStringBuilder.createWithAadApplicationCredentials((String)connectionOptions.getIngestUrl(), (String)connectionOptions.getAppId(), (String)connectionOptions.getAppKey(), (String)connectionOptions.getTenantId());
        ImmutablePair sinkTag = ImmutablePair.of((Object)"sinkType", (Object)sourceClass);
        ImmutablePair clusterTypeTag = ImmutablePair.of((Object)"clusterType", (Object)clusterType);
        KustoClientUtil.setConnectorDetails(kcsb, new Pair[]{sinkTag, clusterTypeTag});
        return kcsb;
    }

    @SafeVarargs
    private static void setConnectorDetails(@NotNull ConnectionStringBuilder kcsb, Pair<String, String> ... additionalOptions) {
        kcsb.setConnectorDetails("Kusto.Flink.Sink", Version.getVersion(), null, null, false, null, additionalOptions);
    }

    private static ConnectionStringBuilder getQueryKcsb(@NotNull KustoConnectionOptions connectionOptions, String sourceClass) {
        ConnectionStringBuilder kcsb = connectionOptions.isManagedIdentity() ? ("system".equalsIgnoreCase(connectionOptions.getManagedIdentityAppId()) ? ConnectionStringBuilder.createWithAadManagedIdentity((String)connectionOptions.getClusterUrl()) : ConnectionStringBuilder.createWithAadManagedIdentity((String)connectionOptions.getClusterUrl(), (String)connectionOptions.getManagedIdentityAppId())) : ConnectionStringBuilder.createWithAadApplicationCredentials((String)connectionOptions.getClusterUrl(), (String)connectionOptions.getAppId(), (String)connectionOptions.getAppKey(), (String)connectionOptions.getTenantId());
        ImmutablePair sinkTag = ImmutablePair.of((Object)"sinkType", (Object)sourceClass);
        ImmutablePair clusterTypeTag = ImmutablePair.of((Object)"clusterType", (Object)"queued");
        KustoClientUtil.setConnectorDetails(kcsb, new Pair[]{sinkTag, clusterTypeTag});
        return kcsb;
    }
}

