/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.config;

import com.microsoft.azure.flink.common.KustoRetryConfig;
import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PublicEvolving
public class KustoConnectionOptions
implements Serializable {
    private static final String INGEST_PREFIX = "ingest-";
    private static final String PROTOCOL_SUFFIX = "://";
    private final String clusterUrl;
    private final String ingestUrl;
    private final String appId;
    private final String appKey;
    private final String tenantId;
    private final boolean isManagedIdentity;
    private final String managedIdentityAppId;
    private final KustoRetryConfig kustoRetryConfig;

    private KustoConnectionOptions(@NotNull Builder builder) {
        this.clusterUrl = (String)Preconditions.checkNotNull((Object)builder.clusterUrl);
        this.ingestUrl = this.clusterUrl.replaceFirst(PROTOCOL_SUFFIX, "://ingest-");
        this.appId = builder.appId;
        this.appKey = builder.appKey;
        this.tenantId = builder.tenantId;
        this.isManagedIdentity = builder.isManagedIdentity;
        this.managedIdentityAppId = builder.managedIdentityAppId;
        this.kustoRetryConfig = builder.kustoRetryConfig;
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public String getIngestUrl() {
        return this.ingestUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isManagedIdentity() {
        return this.isManagedIdentity;
    }

    public String getManagedIdentityAppId() {
        return this.managedIdentityAppId;
    }

    public KustoRetryConfig getKustoRetryConfig() {
        return this.kustoRetryConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KustoConnectionOptions that = (KustoConnectionOptions)o;
        return Objects.equals(this.clusterUrl, that.clusterUrl);
    }

    public int hashCode() {
        return Objects.hash(this.clusterUrl);
    }

    public String toString() {
        return "KustoConnectionOptions{clusterUrl='" + this.clusterUrl + '\'' + ", ingestUrl='" + this.ingestUrl + '\'' + ", appId='" + this.appId + '\'' + ", isManagedIdentity='" + this.isManagedIdentity + '\'' + ", managedIdentityAppId='" + this.managedIdentityAppId + '\'' + '}';
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @PublicEvolving
    public static class Builder {
        private String clusterUrl;
        private String appId;
        private String appKey;
        private String tenantId;
        private boolean isManagedIdentity = false;
        private String managedIdentityAppId;
        private KustoRetryConfig kustoRetryConfig = new KustoRetryConfig.Builder().build();

        private Builder() {
        }

        public Builder withClusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public Builder withAppId(String appId) {
            this.appId = (String)Preconditions.checkNotNull((Object)appId, (String)"The appId for auth must not be null");
            return this;
        }

        public Builder withAppKey(String appKey) {
            this.appKey = (String)Preconditions.checkNotNull((Object)appKey, (String)"The app key for auth must not be null");
            return this;
        }

        public Builder withTenantId(String tenantId) {
            this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId, (String)"The app key for auth must not be null");
            return this;
        }

        public Builder withManagedIdentityAppId(String managedIdentityAppId) {
            this.managedIdentityAppId = (String)Preconditions.checkNotNull((Object)managedIdentityAppId, (String)"The User managed identity for auth must not be null");
            this.isManagedIdentity = true;
            return this;
        }

        public Builder withRetryOptions(KustoRetryConfig kustoRetryConfig) {
            this.kustoRetryConfig = (KustoRetryConfig)Preconditions.checkNotNull((Object)kustoRetryConfig, (String)"If KustoRetryOptions are provided, they must not be null");
            return this;
        }

        public KustoConnectionOptions build() {
            return new KustoConnectionOptions(this);
        }
    }
}

