/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;

public class Utils {
    private static final int MAX_RETRY_ATTEMPTS = 4;
    private static final long MAX_RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    private static final long BASE_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private static final HashSet<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>(){
        {
            this.add(InterruptedIOException.class);
            this.add(UnknownHostException.class);
            this.add(NoRouteToHostException.class);
            this.add(SSLException.class);
        }
    };
    private static final IntervalFunction sleepConfig = IntervalFunction.ofExponentialRandomBackoff((long)BASE_INTERVAL, (double)1.5, (double)0.5, (long)MAX_RETRY_INTERVAL);

    public static ObjectMapper getObjectMapper() {
        return ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).addModule((Module)new JavaTimeModule())).build()).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }

    private Utils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPackageVersion() {
        try {
            Properties props = new Properties();
            try (InputStream versionFileStream = Utils.class.getResourceAsStream("/app.properties");){
                props.load(versionFileStream);
                String string = props.getProperty("version").trim();
                return string;
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String formatDurationAsTimespan(Duration duration) {
        long seconds = duration.getSeconds();
        int nanos = duration.getNano();
        long hours = TimeUnit.SECONDS.toHours(seconds) % TimeUnit.DAYS.toHours(1L);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds) % TimeUnit.MINUTES.toSeconds(1L);
        long secs = seconds % TimeUnit.MINUTES.toSeconds(1L);
        long days = TimeUnit.SECONDS.toDays(seconds);
        String positive = String.format("%02d.%02d:%02d:%02d.%.3s", days, hours, minutes, secs, nanos);
        return seconds < 0L ? "-" + positive : positive;
    }

    public static boolean isRetriableIOException(IOException ex) {
        return !nonRetriableClasses.contains(ex.getClass()) && ex.getMessage() != null && ex.getMessage().contains("timed out");
    }

    public static RetryConfig buildRetryConfig(Class<? extends Throwable> ... errorClasses) {
        return RetryConfig.custom().maxAttempts(4).intervalFunction(sleepConfig).retryExceptions((Class[])errorClasses).build();
    }

    public static RetryConfig buildRetryConfig(Predicate<Throwable> predicate) {
        return RetryConfig.custom().maxAttempts(4).intervalFunction(sleepConfig).retryOnException(predicate).build();
    }
}

