/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.auth.CloudDependentTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsalTokenProviderBase
extends CloudDependentTokenProviderBase {
    protected static final String ERROR_ACQUIRING_APPLICATION_ACCESS_TOKEN = "Error acquiring ApplicationAccessToken";
    protected static final String ORGANIZATION_URI_SUFFIX = "organizations";
    protected static final String ERROR_INVALID_AUTHORITY_URL = "Error acquiring ApplicationAccessToken due to invalid Authority URL";
    protected static final int TIMEOUT_MS = 20000;
    private static final String PERSONAL_TENANT_IDV2_AAD = "9188040d-6c67-4c5b-b112-36a304b66dad";
    private final String authorityId;
    protected String aadAuthorityUrl;
    private String firstPartyAuthorityUrl;

    MsalTokenProviderBase(@NotNull String clusterUrl, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
        this.authorityId = authorityId;
    }

    @Override
    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        super.initializeWithCloudInfo(cloudInfo);
        this.aadAuthorityUrl = this.determineAadAuthorityUrl(cloudInfo);
        this.firstPartyAuthorityUrl = cloudInfo.getFirstPartyAuthorityUrl();
        this.firstPartyAuthorityUrl = StringUtils.appendIfMissing((String)this.firstPartyAuthorityUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private String determineAadAuthorityUrl(CloudInfo cloudInfo) throws DataClientException {
        String aadAuthorityUrlFromEnv = System.getenv("AadAuthorityUri");
        String authorityIdToUse = this.authorityId != null ? this.authorityId : ORGANIZATION_URI_SUFFIX;
        try {
            return UriUtils.setPathForUri(aadAuthorityUrlFromEnv == null ? cloudInfo.getLoginEndpoint() : aadAuthorityUrlFromEnv, authorityIdToUse, true);
        }
        catch (URISyntaxException e) {
            throw new DataClientException(this.clusterUrl, ERROR_INVALID_AUTHORITY_URL, e);
        }
    }

    @Override
    protected String acquireAccessTokenImpl() throws DataServiceException, DataClientException {
        IAuthenticationResult accessTokenResult = this.acquireAccessTokenSilently();
        if (accessTokenResult == null) {
            accessTokenResult = MonitoredActivity.invoke(this::acquireNewAccessToken, this.getAuthMethod().concat(".acquireNewAccessToken"));
        }
        return accessTokenResult.accessToken();
    }

    protected IAuthenticationResult acquireAccessTokenSilently() throws DataServiceException, DataClientException {
        try {
            return this.acquireAccessTokenSilentlyMsal();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, ERROR_INVALID_AUTHORITY_URL, e);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected abstract IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException, DataServiceException;

    protected abstract IAuthenticationResult acquireNewAccessToken() throws DataServiceException, DataClientException;

    SilentParameters getSilentParameters(Set<IAccount> accountSet) {
        IAccount account = this.getAccount(accountSet);
        if (account != null) {
            String authorityUrl = this.aadAuthorityUrl;
            if (account.homeAccountId() != null && account.homeAccountId().endsWith(PERSONAL_TENANT_IDV2_AAD)) {
                authorityUrl = this.firstPartyAuthorityUrl;
            }
            return SilentParameters.builder((Set)this.scopes).account(account).authorityUrl(authorityUrl).build();
        }
        return SilentParameters.builder((Set)this.scopes).authorityUrl(this.aadAuthorityUrl).build();
    }

    IAccount getAccount(Set<IAccount> accountSet) {
        if (accountSet.isEmpty()) {
            return null;
        }
        return accountSet.iterator().next();
    }
}

