// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.UserIdentity;
import com.microsoft.graph.models.generated.PrintJobProcessingState;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Archived Print Job.
 */
public class ArchivedPrintJob implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Acquired By Printer.
     * True if the job was acquired by a printer; false otherwise. Read-only.
     */
    @SerializedName(value = "acquiredByPrinter", alternate = {"AcquiredByPrinter"})
    @Expose
    public Boolean acquiredByPrinter;

    /**
     * The Acquired Date Time.
     * The dateTimeOffset when the job was acquired by the printer, if any. Read-only.
     */
    @SerializedName(value = "acquiredDateTime", alternate = {"AcquiredDateTime"})
    @Expose
    public java.util.Calendar acquiredDateTime;

    /**
     * The Completion Date Time.
     * The dateTimeOffset when the job was completed, canceled or aborted. Read-only.
     */
    @SerializedName(value = "completionDateTime", alternate = {"CompletionDateTime"})
    @Expose
    public java.util.Calendar completionDateTime;

    /**
     * The Copies Printed.
     * The number of copies that were printed. Read-only.
     */
    @SerializedName(value = "copiesPrinted", alternate = {"CopiesPrinted"})
    @Expose
    public Integer copiesPrinted;

    /**
     * The Created By.
     * The user who created the print job. Read-only.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
    public UserIdentity createdBy;

    /**
     * The Created Date Time.
     * The dateTimeOffset when the job was created. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Id.
     * The archived print job's GUID. Read-only.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
    public String id;

    /**
     * The Printer Id.
     * The printer ID that the job was queued for. Read-only.
     */
    @SerializedName(value = "printerId", alternate = {"PrinterId"})
    @Expose
    public String printerId;

    /**
     * The Processing State.
     * The print job's final processing state. Read-only.
     */
    @SerializedName(value = "processingState", alternate = {"ProcessingState"})
    @Expose
    public PrintJobProcessingState processingState;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
