// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ApplicationTemplate;
import com.microsoft.graph.models.extensions.ApplicationServicePrincipal;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Template Request.
 */
public class ApplicationTemplateRequest extends BaseRequest implements IApplicationTemplateRequest {
	
    /**
     * The request for the ApplicationTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ApplicationTemplateRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationTemplate.class);
    }

    /**
     * Gets the ApplicationTemplate from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super ApplicationTemplate> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ApplicationTemplate from the service
     *
     * @return the ApplicationTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ApplicationTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super ApplicationTemplate> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ApplicationTemplate with a source
     *
     * @param sourceApplicationTemplate the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ApplicationTemplate sourceApplicationTemplate, final ICallback<? super ApplicationTemplate> callback) {
        send(HttpMethod.PATCH, callback, sourceApplicationTemplate);
    }

    /**
     * Patches this ApplicationTemplate with a source
     *
     * @param sourceApplicationTemplate the source object with updates
     * @return the updated ApplicationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ApplicationTemplate patch(final ApplicationTemplate sourceApplicationTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceApplicationTemplate);
    }

    /**
     * Creates a ApplicationTemplate with a new object
     *
     * @param newApplicationTemplate the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ApplicationTemplate newApplicationTemplate, final ICallback<? super ApplicationTemplate> callback) {
        send(HttpMethod.POST, callback, newApplicationTemplate);
    }

    /**
     * Creates a ApplicationTemplate with a new object
     *
     * @param newApplicationTemplate the new object to create
     * @return the created ApplicationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ApplicationTemplate post(final ApplicationTemplate newApplicationTemplate) throws ClientException {
        return send(HttpMethod.POST, newApplicationTemplate);
    }

    /**
     * Creates a ApplicationTemplate with a new object
     *
     * @param newApplicationTemplate the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ApplicationTemplate newApplicationTemplate, final ICallback<? super ApplicationTemplate> callback) {
        send(HttpMethod.PUT, callback, newApplicationTemplate);
    }

    /**
     * Creates a ApplicationTemplate with a new object
     *
     * @param newApplicationTemplate the object to create/update
     * @return the created ApplicationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ApplicationTemplate put(final ApplicationTemplate newApplicationTemplate) throws ClientException {
        return send(HttpMethod.PUT, newApplicationTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IApplicationTemplateRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ApplicationTemplateRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IApplicationTemplateRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ApplicationTemplateRequest)this;
     }

}

