// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AdministrativeUnit;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IServicePrincipalWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrgContactWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Administrative Unit Request Builder.
 */
public interface IAdministrativeUnitRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IAdministrativeUnitRequest instance
     */
    IAdministrativeUnitRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IAdministrativeUnitRequest instance
     */
    IAdministrativeUnitRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IDirectoryObjectCollectionWithReferencesRequestBuilder members();

    IDirectoryObjectWithReferenceRequestBuilder members(final String id);

    IUserCollectionWithReferencesRequestBuilder membersAsUser();

    IUserWithReferenceRequestBuilder membersAsUser(final String id);

    IGroupCollectionWithReferencesRequestBuilder membersAsGroup();

    IGroupWithReferenceRequestBuilder membersAsGroup(final String id);

    IApplicationCollectionWithReferencesRequestBuilder membersAsApplication();

    IApplicationWithReferenceRequestBuilder membersAsApplication(final String id);

    IServicePrincipalCollectionWithReferencesRequestBuilder membersAsServicePrincipal();

    IServicePrincipalWithReferenceRequestBuilder membersAsServicePrincipal(final String id);

    IDeviceCollectionWithReferencesRequestBuilder membersAsDevice();

    IDeviceWithReferenceRequestBuilder membersAsDevice(final String id);

    IOrgContactCollectionWithReferencesRequestBuilder membersAsOrgContact();

    IOrgContactWithReferenceRequestBuilder membersAsOrgContact(final String id);

    IScopedRoleMembershipCollectionRequestBuilder scopedRoleMembers();

    IScopedRoleMembershipRequestBuilder scopedRoleMembers(final String id);

    IExtensionCollectionRequestBuilder extensions();

    IExtensionRequestBuilder extensions(final String id);

}