// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PolicyBase;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Policy Base Request.
 */
public interface IPolicyBaseRequest extends IHttpRequest {

    /**
     * Gets the PolicyBase from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PolicyBase> callback);

    /**
     * Gets the PolicyBase from the service
     *
     * @return the PolicyBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyBase get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PolicyBase> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PolicyBase with a source
     *
     * @param sourcePolicyBase the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PolicyBase sourcePolicyBase, final ICallback<? super PolicyBase> callback);

    /**
     * Patches this PolicyBase with a source
     *
     * @param sourcePolicyBase the source object with updates
     * @return the updated PolicyBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyBase patch(final PolicyBase sourcePolicyBase) throws ClientException;

    /**
     * Posts a PolicyBase with a new object
     *
     * @param newPolicyBase the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PolicyBase newPolicyBase, final ICallback<? super PolicyBase> callback);

    /**
     * Posts a PolicyBase with a new object
     *
     * @param newPolicyBase the new object to create
     * @return the created PolicyBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyBase post(final PolicyBase newPolicyBase) throws ClientException;

    /**
     * Posts a PolicyBase with a new object
     *
     * @param newPolicyBase the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PolicyBase newPolicyBase, final ICallback<? super PolicyBase> callback);

    /**
     * Posts a PolicyBase with a new object
     *
     * @param newPolicyBase the object to create/update
     * @return the created PolicyBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PolicyBase put(final PolicyBase newPolicyBase) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPolicyBaseRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPolicyBaseRequest expand(final String value);

}

