// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintConnector;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.PrintConnector;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Connector With Reference Request.
 */
public interface IPrintConnectorWithReferenceRequest extends IHttpRequest {

    void post(final PrintConnector newPrintConnector, final IJsonBackedObject payload, final ICallback<? super PrintConnector> callback);

    PrintConnector post(final PrintConnector newPrintConnector, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super PrintConnector> callback);

    PrintConnector get() throws ClientException;

	void delete(final ICallback<? super PrintConnector> callback);

	void delete() throws ClientException;

	void patch(final PrintConnector sourcePrintConnector, final ICallback<? super PrintConnector> callback);

	PrintConnector patch(final PrintConnector sourcePrintConnector) throws ClientException;

    IPrintConnectorWithReferenceRequest select(final String value);

    IPrintConnectorWithReferenceRequest expand(final String value);

}
