// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrintUsage;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Usage Request.
 */
public interface IPrintUsageRequest extends IHttpRequest {

    /**
     * Gets the PrintUsage from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrintUsage> callback);

    /**
     * Gets the PrintUsage from the service
     *
     * @return the PrintUsage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintUsage get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrintUsage> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrintUsage with a source
     *
     * @param sourcePrintUsage the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrintUsage sourcePrintUsage, final ICallback<? super PrintUsage> callback);

    /**
     * Patches this PrintUsage with a source
     *
     * @param sourcePrintUsage the source object with updates
     * @return the updated PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintUsage patch(final PrintUsage sourcePrintUsage) throws ClientException;

    /**
     * Posts a PrintUsage with a new object
     *
     * @param newPrintUsage the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrintUsage newPrintUsage, final ICallback<? super PrintUsage> callback);

    /**
     * Posts a PrintUsage with a new object
     *
     * @param newPrintUsage the new object to create
     * @return the created PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintUsage post(final PrintUsage newPrintUsage) throws ClientException;

    /**
     * Posts a PrintUsage with a new object
     *
     * @param newPrintUsage the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrintUsage newPrintUsage, final ICallback<? super PrintUsage> callback);

    /**
     * Posts a PrintUsage with a new object
     *
     * @param newPrintUsage the object to create/update
     * @return the created PrintUsage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintUsage put(final PrintUsage newPrintUsage) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrintUsageRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrintUsageRequest expand(final String value);

}

