// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TimeOffRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Time Off Request Request.
 */
public interface ITimeOffRequestRequest extends IHttpRequest {

    /**
     * Gets the TimeOffRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TimeOffRequest> callback);

    /**
     * Gets the TimeOffRequest from the service
     *
     * @return the TimeOffRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TimeOffRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TimeOffRequest with a source
     *
     * @param sourceTimeOffRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TimeOffRequest sourceTimeOffRequest, final ICallback<? super TimeOffRequest> callback);

    /**
     * Patches this TimeOffRequest with a source
     *
     * @param sourceTimeOffRequest the source object with updates
     * @return the updated TimeOffRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffRequest patch(final TimeOffRequest sourceTimeOffRequest) throws ClientException;

    /**
     * Posts a TimeOffRequest with a new object
     *
     * @param newTimeOffRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TimeOffRequest newTimeOffRequest, final ICallback<? super TimeOffRequest> callback);

    /**
     * Posts a TimeOffRequest with a new object
     *
     * @param newTimeOffRequest the new object to create
     * @return the created TimeOffRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffRequest post(final TimeOffRequest newTimeOffRequest) throws ClientException;

    /**
     * Posts a TimeOffRequest with a new object
     *
     * @param newTimeOffRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TimeOffRequest newTimeOffRequest, final ICallback<? super TimeOffRequest> callback);

    /**
     * Posts a TimeOffRequest with a new object
     *
     * @param newTimeOffRequest the object to create/update
     * @return the created TimeOffRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TimeOffRequest put(final TimeOffRequest newTimeOffRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITimeOffRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITimeOffRequestRequest expand(final String value);

}

