// Template Source: BaseMethodCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ArchivedPrintJob;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ReportRootGetGroupArchivedPrintJobsCollectionPage;
import com.microsoft.graph.requests.extensions.ReportRootGetGroupArchivedPrintJobsCollectionResponse;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Get Group Archived Print Jobs Collection Request.
 */
public class ReportRootGetGroupArchivedPrintJobsCollectionRequest extends BaseCollectionRequest<ReportRootGetGroupArchivedPrintJobsCollectionResponse, IReportRootGetGroupArchivedPrintJobsCollectionPage> implements IReportRootGetGroupArchivedPrintJobsCollectionRequest {


    /**
     * The request for this ReportRootGetGroupArchivedPrintJobs
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReportRootGetGroupArchivedPrintJobsCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReportRootGetGroupArchivedPrintJobsCollectionResponse.class, IReportRootGetGroupArchivedPrintJobsCollectionPage.class);
    }


    public void get(final ICallback<? super IReportRootGetGroupArchivedPrintJobsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IReportRootGetGroupArchivedPrintJobsCollectionPage get() throws ClientException {
        final ReportRootGetGroupArchivedPrintJobsCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IReportRootGetGroupArchivedPrintJobsCollectionPage buildFromResponse(final ReportRootGetGroupArchivedPrintJobsCollectionResponse response) {
        final IReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, (String) null, (java.util.Calendar) null, (java.util.Calendar) null);
        } else {
            builder = null;
        }
        final IReportRootGetGroupArchivedPrintJobsCollectionPage page = new ReportRootGetGroupArchivedPrintJobsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IReportRootGetGroupArchivedPrintJobsCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (IReportRootGetGroupArchivedPrintJobsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IReportRootGetGroupArchivedPrintJobsCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value+""));
        return (IReportRootGetGroupArchivedPrintJobsCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IReportRootGetGroupArchivedPrintJobsCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (IReportRootGetGroupArchivedPrintJobsCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IReportRootGetGroupArchivedPrintJobsCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (IReportRootGetGroupArchivedPrintJobsCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IReportRootGetGroupArchivedPrintJobsCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (IReportRootGetGroupArchivedPrintJobsCollectionRequest)this;
    }

}
