/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantDeltaCollectionResponse;
import java.util.List;

public class OAuth2PermissionGrantDeltaCollectionRequest
extends BaseCollectionRequest<OAuth2PermissionGrantDeltaCollectionResponse, IOAuth2PermissionGrantDeltaCollectionPage>
implements IOAuth2PermissionGrantDeltaCollectionRequest {
    public OAuth2PermissionGrantDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantDeltaCollectionResponse.class, IOAuth2PermissionGrantDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOAuth2PermissionGrantDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OAuth2PermissionGrantDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOAuth2PermissionGrantDeltaCollectionPage get() throws ClientException {
        OAuth2PermissionGrantDeltaCollectionResponse response = (OAuth2PermissionGrantDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IOAuth2PermissionGrantDeltaCollectionPage buildFromResponse(OAuth2PermissionGrantDeltaCollectionResponse response) {
        OAuth2PermissionGrantDeltaCollectionRequestBuilder builder = response.nextLink != null ? new OAuth2PermissionGrantDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OAuth2PermissionGrantDeltaCollectionPage page = new OAuth2PermissionGrantDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IOAuth2PermissionGrantDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IOAuth2PermissionGrantDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IOAuth2PermissionGrantDeltaCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

