/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.PrintService;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintServiceRequest;
import java.util.List;

public class PrintServiceRequest
extends BaseRequest
implements IPrintServiceRequest {
    public PrintServiceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintService.class);
    }

    @Override
    public void get(ICallback<? super PrintService> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public PrintService get() throws ClientException {
        return (PrintService)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super PrintService> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(PrintService sourcePrintService, ICallback<? super PrintService> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePrintService);
    }

    @Override
    public PrintService patch(PrintService sourcePrintService) throws ClientException {
        return (PrintService)this.send(HttpMethod.PATCH, sourcePrintService);
    }

    @Override
    public void post(PrintService newPrintService, ICallback<? super PrintService> callback) {
        this.send(HttpMethod.POST, callback, newPrintService);
    }

    @Override
    public PrintService post(PrintService newPrintService) throws ClientException {
        return (PrintService)this.send(HttpMethod.POST, newPrintService);
    }

    @Override
    public void put(PrintService newPrintService, ICallback<? super PrintService> callback) {
        this.send(HttpMethod.PUT, callback, newPrintService);
    }

    @Override
    public PrintService put(PrintService newPrintService) throws ClientException {
        return (PrintService)this.send(HttpMethod.PUT, newPrintService);
    }

    @Override
    public IPrintServiceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintServiceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

