/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrinterShare;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionPage;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionRequest;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionPage;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionResponse;
import com.microsoft.graph.requests.extensions.PrinterShareRequestBuilder;
import java.util.List;

public class PrinterShareCollectionRequest
extends BaseCollectionRequest<PrinterShareCollectionResponse, IPrinterShareCollectionPage>
implements IPrinterShareCollectionRequest {
    public PrinterShareCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShareCollectionResponse.class, IPrinterShareCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrinterShareCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrinterShareCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrinterShareCollectionPage get() throws ClientException {
        PrinterShareCollectionResponse response = (PrinterShareCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrinterShare newPrinterShare, ICallback<? super PrinterShare> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrinterShareRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinterShare, callback);
    }

    @Override
    public PrinterShare post(PrinterShare newPrinterShare) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrinterShareRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinterShare);
    }

    @Override
    public IPrinterShareCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrinterShareCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrinterShareCollectionPage buildFromResponse(PrinterShareCollectionResponse response) {
        PrinterShareCollectionRequestBuilder builder = response.nextLink != null ? new PrinterShareCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrinterShareCollectionPage page = new PrinterShareCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

