// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Template.
 */
public class ApplicationTemplate extends Entity implements IJsonBackedObject {


    /**
     * The Categories.
     * The list of categories for the application. Supported values can be: Collaboration, Business Management, Consumer,Content management, CRM, Data services, Developer services, E-commerce, Education, ERP, Finance, Health, Human resources, IT infrastructure, Mail, Management, Marketing, Media, Productivity, Project management, Telecommunications, Tools, Travel, and Web design &amp; hosting.
     */
    @SerializedName(value = "categories", alternate = {"Categories"})
    @Expose
    public java.util.List<String> categories;

    /**
     * The Description.
     * A description of the application.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
    public String description;

    /**
     * The Display Name.
     * The name of the application.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Home Page Url.
     * The home page URL of the application.
     */
    @SerializedName(value = "homePageUrl", alternate = {"HomePageUrl"})
    @Expose
    public String homePageUrl;

    /**
     * The Logo Url.
     * The URL to get the logo for this application.
     */
    @SerializedName(value = "logoUrl", alternate = {"LogoUrl"})
    @Expose
    public String logoUrl;

    /**
     * The Publisher.
     * The name of the publisher for this application.
     */
    @SerializedName(value = "publisher", alternate = {"Publisher"})
    @Expose
    public String publisher;

    /**
     * The Supported Provisioning Types.
     * The list of provisioning modes supported by this application. The only valid value is sync.
     */
    @SerializedName(value = "supportedProvisioningTypes", alternate = {"SupportedProvisioningTypes"})
    @Expose
    public java.util.List<String> supportedProvisioningTypes;

    /**
     * The Supported Single Sign On Modes.
     * The list of single sign-on modes supported by this application. The supported values are password, saml, external, and oidc.
     */
    @SerializedName(value = "supportedSingleSignOnModes", alternate = {"SupportedSingleSignOnModes"})
    @Expose
    public java.util.List<String> supportedSingleSignOnModes;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
