// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Notebook;
import com.microsoft.graph.models.extensions.SectionGroup;
import com.microsoft.graph.models.extensions.OnenoteSection;
import com.microsoft.graph.models.extensions.OnenoteEntityHierarchyModel;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Section Group.
 */
public class SectionGroup extends OnenoteEntityHierarchyModel implements IJsonBackedObject {


    /**
     * The Section Groups Url.
     * The URL for the sectionGroups navigation property, which returns all the section groups in the section group. Read-only.
     */
    @SerializedName(value = "sectionGroupsUrl", alternate = {"SectionGroupsUrl"})
    @Expose
    public String sectionGroupsUrl;

    /**
     * The Sections Url.
     * The URL for the sections navigation property, which returns all the sections in the section group. Read-only.
     */
    @SerializedName(value = "sectionsUrl", alternate = {"SectionsUrl"})
    @Expose
    public String sectionsUrl;

    /**
     * The Parent Notebook.
     * The notebook that contains the section group. Read-only.
     */
    @SerializedName(value = "parentNotebook", alternate = {"ParentNotebook"})
    @Expose
    public Notebook parentNotebook;

    /**
     * The Parent Section Group.
     * The section group that contains the section group. Read-only.
     */
    @SerializedName(value = "parentSectionGroup", alternate = {"ParentSectionGroup"})
    @Expose
    public SectionGroup parentSectionGroup;

    /**
     * The Section Groups.
     * The section groups in the section. Read-only. Nullable.
     */
    @SerializedName(value = "sectionGroups", alternate = {"SectionGroups"})
    @Expose
    public SectionGroupCollectionPage sectionGroups;

    /**
     * The Sections.
     * The sections in the section group. Read-only. Nullable.
     */
    @SerializedName(value = "sections", alternate = {"Sections"})
    @Expose
    public OnenoteSectionCollectionPage sections;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("sectionGroups")) {
            sectionGroups = serializer.deserializeObject(json.get("sectionGroups").toString(), SectionGroupCollectionPage.class);
        }

        if (json.has("sections")) {
            sections = serializer.deserializeObject(json.get("sections").toString(), OnenoteSectionCollectionPage.class);
        }
    }
}
